#include "_p.h"
#include <crtdbg.h>

#include "../oralib/oralib.h"


int main (void)
{
	oralib::connection cn;

	try
	{
	cn.open ("ora1", "thesis", "thesis");
	oralib::resultset &rs = *cn.select (
		"select OBJECT_NAME, OBJECT_TYPE, TIMESTAMP, STATUS from OBJ");
	oralib::column &col = rs ["OBJECT_TYPE"];
	while (!rs.eod ())
	{
		_tprintf (_T ("%-18s %-18s %-20s %s\n"),
			(oralib::Pstr) rs ["OBJECT_NAME"],
			(oralib::Pstr) col,
			(oralib::Pstr) rs [3],
			(oralib::Pstr) rs [4]);
		rs.next ();
	}
	rs.release ();
	cn.close ();
	}
	catch (oralib::error &e)
	{
		std::cout << e.details ();
	}
	return (0);
}


int main1 (void)
{
	oralib::connection c;
	const int ITERS = 10;

	_CrtSetDbgFlag (
		_CRTDBG_ALLOC_MEM_DF |
		_CRTDBG_LEAK_CHECK_DF);

	c.open ("ora1", "thesis", "thesis");

	try
	{
		oralib::statement &s1 = *c.prepare ("insert into a values (:n1)");
		oralib::statement &s2 = *c.prepare ("insert into b values (:s1)");
		oralib::statement &s3 = *c.prepare ("insert into c values (:s1)");

		oralib::parameter &p1 = s1.bind (":n1");
		oralib::parameter &p2 = s2.bind (":s1");
		oralib::parameter &p3 = s3.bind (":s1");

		p2 = _T ("Hello, World!");
		p3 = _T ("Hello, World!");

		for (int i=0; i<ITERS; ++i, p1 = (long) i)
		{
			s1.execute ();
			s2.execute ();
			s3.execute ();
		}
		s3.release ();
		s2.release ();
		s1.release ();

		s1 = *c.prepare ("create table e ( s varchar(10) )");
		s1.execute ();
		s1.release ();

	}
	catch (oralib::error &e)
	{
		std::cout << e.details ();
	}
	
	c.close ();
	return (0);
}
