#if defined (_MINGW)
#	define	_STLP_NO_OWN_IOSTREAMS
#endif

#include "_p.h"

#if defined (_MSC_VER) && !defined (_MINGW)
#	include <crtdbg.h>
#endif

#include "../oralib/oralib.h"

using namespace oralib;
using namespace std;

int main (void)
{
	const long ITERS = 1000;
	const char *phrase = "Hello, World!";

#if	defined (_MSC_VER) && !defined (_MINGW) // Microsoft Visual C++
	_CrtSetDbgFlag (
		_CRTDBG_ALLOC_MEM_DF |
		//_CRTDBG_CHECK_ALWAYS_DF |
		//_CRTDBG_DELAY_FREE_MEM_DF |
		_CRTDBG_LEAK_CHECK_DF);
#endif

	try
	{
		// change those to whatever works for you
		connection cn ("ora1", "thesis", "thesis");

		cn.execute ("create table oralib_test ( n numeric, d date, s varchar2 (50) )");
		cn.execute ("create unique index oralib_test_ndx on oralib_test (n)");

		// fast inserts
		statement &st1 = *cn.prepare (
			"insert into oralib_test (n, d, s) values (:n, :d, :s)");
		parameter &pn = st1.bind (":n");
		parameter &pd = st1.bind (":d");
		parameter &ps = st1.bind (":s");
		long i, d = 1;
		cout << "insertion...";
		for (i=0; i<ITERS; i++)
		{
			pn = i;
			pd = datetime ((ub1) d, jan, 2002);
			if (++d > 31) d = 1;
			ps = phrase;
			st1.execute ();
		}
		ps.release ();
		pd.release ();
		pn.release ();
		st1.release ();
		cout << "\n";

		// prepared select statement with named parameter
		cout << "checking...";
		statement &st2 = *cn.prepare (
			"select n, d, s from oralib_test where n = :n");
		parameter &pn1 = st2.bind (":n");
		d = 1;
		for (i=0; i<ITERS; i++)
		{
			pn1 = i;
			resultset &rs = *st2.select ();
			long n_column = rs ["N"];
			datetime d_column = rs ["D"];
			Pstr s_column = rs ["S"];
			ASSERT (n_column == i &&
				d_column.day () == d &&
				strcmp (s_column, phrase) == 0);
			rs.release ();
			if (++d > 31) d = 1;
		}
		pn1.release ();
		st2.release ();
		cout << "\n";

		// regular select statement
		cout << "checking, part 2...";
		resultset &rs = *cn.select (
			"select n, d, s from oralib_test");
		d = 1;
		i = 0;
		do
		{
			long n_column = rs ["N"];
			datetime d_column = rs ["D"];
			Pstr s_column = rs ["S"];
			ASSERT (n_column == i &&
				d_column.day () == d &&
				strcmp (s_column, phrase) == 0);
			i++;
			if (++d > 31) d = 1;
		}
		while (++rs);
		rs.release ();
		cout << "\n";

		cn.execute ("drop table oralib_test");

		cn.close ();
	}
	catch (oralib::error &e)
	{
		cout << e.details ();
	}
	catch (...)
	{
		cout << "unrecognized error occured!\n";
	}
	return (0);
}
