# OraLib 0.0.4 / 2002-07-28
#	Makefile for BCC 5.5 (Borland's free command-line tools)
#
#	http://606u.dir.bg/
#	606u@dir.bg


# ---------------------------
# C O N F I G U R E   H E R E
#
BCC_BASE = c:\borland\bcc55
STLPORT_BASE = e:\stlport-4.5.3
ORACLE_BASE = e:\oracle\ora81
#
#  E N D   C O N F I G U R E
# ---------------------------


# do not change lines below


# switches for include files directories and library files directories
HEADERS = \
	-I$(STLPORT_BASE)\stlport \
	-I$(ORACLE_BASE)\oci\include \
	-I$(BCC_BASE)\include

LIBRARIES = \
	-L$(STLPORT_BASE)\lib\bcc \
	-L$(ORACLE_BASE)\oci\lib\bc \
	-L$(BCC_BASE)\lib


# compilers and flags
CXX = bcc32
CXXFLAGS = $(HEADERS) $(LIBRARIES)


# dependencies
DEPS = oralib.h error.h datetime.inl connection.h column.h \
	resultset.h statement.h parameter.h


# output library file name
ORALIB = oralib-bcc.lib



# default target
all : $(ORALIB)


# clean target
clean :
	@if exist "*.obj" del *.obj


$(ORALIB) : column.obj connection.obj error.obj \
	parameter.obj resultset.obj statement.obj


column.obj : column.cpp $(DEPS)
connection.obj : connection.cpp $(DEPS)
error.obj : error.cpp $(DEPS)
parameter.obj : parameter.cpp $(DEPS)
resultset.obj : resultset.cpp $(DEPS)
statement.obj : statement.cpp $(DEPS)


.cpp.obj :
	$(CXX) $(CXXFLAGS) -P -c $< -o $@


$(ORALIB) :
	@if exist "$(ORALIB)" del $(ORALIB)
	tlib "$(ORALIB)" /a column.obj connection.obj error.obj \
		parameter.obj resultset.obj statement.obj
