// OraLib 0.0.4 / 2002-07-28
//	datetime.inl
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_DATETIME_INL
#define	_DATETIME_INL


namespace oralib {


enum MonthsEnum
{
	jan = 1,
	feb,
	mar,
	apr,
	may,
	jun,
	jul,
	aug,
	sep,
	oct,
	nov,
	dec
};


// helper date/time class with no input validation at all
class datetime
{
private:
	sb2		y;
	MonthsEnum	m;
	ub1		d;
	ub1		h;
	ub1		i;
	ub1		s;

public:
	inline datetime (void) {};

	inline datetime (
		IN ub1 dd,
		IN MonthsEnum mm,
		IN ub2 yyyy,
		IN OPTIONAL ub1 hh = 0,
		IN OPTIONAL ub1 mi = 0,
		IN OPTIONAL ub1 ss = 0) : y (yyyy), m (mm), d (dd), h (hh), i (mi), s (ss)
		{ };

	inline datetime (
		IN const OCIDate& o)
		{ operator = (o); };

public:
	inline ub1 day (void) const { return (d); };
	inline void day (
		IN ub1 dd)
		{ d = dd; };

	inline MonthsEnum mon (void) const
		{ return (m); };
	inline void mon (
		IN MonthsEnum mm)
		{ m = mm; };

	inline sb2 year (void) const
		{ return (y); };
	inline void year (
		IN sb2 yy)
		{ y = yy; };

	inline ub1 hour (void) const
		{ return (h); };
	inline void hour (
		IN ub1 hh)
		{ h = hh; };

	inline ub1 minute (void) const
		{ return (i); };
	inline void minute (
		IN ub1 mi)
		{ i = mi; };

	inline ub1 sec (void) const
		{ return (s); };
	inline void sec (
		IN ub1 ss)
		{ s = ss; };

	inline datetime& operator = (
		IN const OCIDate& o)
	{
		y = o.OCIDateYYYY;
		m = (MonthsEnum) (o.OCIDateMM);
		d = o.OCIDateDD;
		h = o.OCIDateTime.OCITimeHH;
		i = o.OCIDateTime.OCITimeMI;
		s = o.OCIDateTime.OCITimeSS;
		return (*this);
	};
	inline void set (
		OUT OCIDate& o) const
	{
		o.OCIDateYYYY = y;
		o.OCIDateMM = static_cast <ub1> (m);
		o.OCIDateDD = d;
		o.OCIDateTime.OCITimeHH = h;
		o.OCIDateTime.OCITimeMI = i;
		o.OCIDateTime.OCITimeSS = s;
	};

}; // datetime class


}; // oralib namespace


#endif // _DATETIME_INL
