# OraLib 0.0.4 / 2002-07-28
#	Makefile for MinGW (tested with 1.1)
#
#	http://606u.dir.bg/
#	606u@dir.bg


# ---------------------------
# C O N F I G U R E   H E R E
#
MINGW_BASE = c:\mingw
STLPORT_BASE = e:\stlport-4.5.3
ORACLE_BASE = e:\oracle\ora81
#
#  E N D   C O N F I G U R E
# ---------------------------


# do not change lines below


# switches for include files directories and library files directories
HEADERS = \
	-I$(STLPORT_BASE)\stlport \
	-I$(ORACLE_BASE)\oci\include \
	-I$(MINGW_BASE)\include

LIBRARIES = \
	-L$(STLPORT_BASE)\lib\mingw \
	-L$(ORACLE_BASE)\oci\lib\bc \
	-L$(MINGW_BASE)\lib


# compilers and flags
CXX = gcc
CXXFLAGS = $(HEADERS) $(LIBRARIES) -D_MINGW


# dependencies
DEPS = oralib.h error.h datetime.inl connection.h column.h \
	resultset.h statement.h parameter.h


# output library file name
LIBORALIB = liboralib.a
LIBOCI = liboci.a


# default target
all : $(LIBORALIB) $(LIBOCI)


# clean target
clean :
	@if exist "*.o" del *.o


$(LIBORALIB) : column.o connection.o error.o \
	parameter.o resultset.o statement.o


column.o : column.cpp $(DEPS)
connection.o : connection.cpp $(DEPS)
error.o : error.cpp $(DEPS)
parameter.o : parameter.cpp $(DEPS)
resultset.o : resultset.cpp $(DEPS)
statement.o : statement.cpp $(DEPS)


.cpp.o :
	$(CXX) $(CXXFLAGS) -c $< -o $@


$(LIBORALIB) :
	@if exist "$(LIBORALIB)" del $(LIBORALIB)
	ar -q $(LIBORALIB) column.o connection.o error.o \
		parameter.o resultset.o statement.o


$(LIBOCI) : oci.def
	dlltool -d oci.def -l liboci.a
