// Dialog.cpp : implementation file
//

#include "stdafx.h"
#include "xguidemo.h"
#include "Dialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CXDlg dialog

CXDlg::CXDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CXDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CXDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CXDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXDlg)
	DDX_Control(pDX, IDC_WEB_PALETTE, m_wndWebColors);
	DDX_Control(pDX, IDC_C3, m_wndComp3);
	DDX_Control(pDX, IDC_C2, m_wndComp2);
	DDX_Control(pDX, IDC_C1, m_wndComp1);
	DDX_Control(pDX, IDC_COLOR, m_wndColor);
	DDX_Control(pDX, IDC_LINK_BOTH, m_wndLinkBoth);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CXDlg, CDialog)
	//{{AFX_MSG_MAP(CXDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RED, OnRed)
	ON_BN_CLICKED(IDC_GREEN, OnGreen)
	ON_BN_CLICKED(IDC_BLUE, OnBlue)
	ON_BN_CLICKED(IDC_HUE, OnHue)
	ON_BN_CLICKED(IDC_SAT, OnSat)
	ON_BN_CLICKED(IDC_VALUE, OnValue)
	ON_BN_CLICKED(IDC_RGB, OnRgb)
	ON_BN_CLICKED(IDC_HSV, OnHsv)
	ON_BN_CLICKED(IDC_HLSHUE, OnHlsHue)
	ON_BN_CLICKED(IDC_HLSLIGHT, OnHlsLight)
	ON_BN_CLICKED(IDC_HLSSAT, OnHlsSat)
	ON_BN_CLICKED(IDC_HLS, OnHls)
	ON_BN_CLICKED(IDC_WEB_PALETTE, OnWebPalette)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXDlg message handlers


BOOL CXDlg::OnInitDialog ()
{
	CDialog::OnInitDialog ();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	master1.attach (
		GetDlgItem (IDC_CONTROLLER1)->m_hWnd);
	master1.setup_as_picker (
		GetDlgItem (IDC_WELL1)->m_hWnd,
		GetDlgItem (IDC_PICKER)->m_hWnd,
		GetDlgItem (IDC_VSLIDER)->m_hWnd);

	master2.attach (
		GetDlgItem (IDC_CONTROLLER2)->m_hWnd);
	master2.setup_as_sliders (
		GetDlgItem (IDC_WELL2)->m_hWnd,
		GetDlgItem (IDC_SLIDER1)->m_hWnd,
		GetDlgItem (IDC_SLIDER2)->m_hWnd,
		GetDlgItem (IDC_SLIDER3)->m_hWnd);

	// preselect both combos
	((CButton *) GetDlgItem (IDC_RED))->SetCheck (1);
	((CButton *) GetDlgItem (IDC_RGB))->SetCheck (1);

	RECT rc;
	GetDlgItem (IDC_PICKER)->GetWindowRect (&rc);
	ScreenToClient (&rc);
	rc.right = rc.left + 5 + 2 + 256 + 2 + 5;
	rc.bottom = rc.top + 5 + 2 + 256 + 2 + 5;
	GetDlgItem (IDC_PICKER)->MoveWindow (&rc, TRUE);

	GetDlgItem (IDC_VSLIDER)->GetWindowRect (&rc);
	ScreenToClient (&rc);
	rc.bottom = rc.top + 5 + 2 + 256 + 2 + 5;
	GetDlgItem (IDC_VSLIDER)->MoveWindow (&rc, TRUE);

	OnRed ();
	OnRgb ();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}


// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.
void CXDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}


// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CXDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CXDlg::OnRed() 
{
	master1.visual (xgui::modes::rgb_red | xgui::modes::reverse);
}


void CXDlg::OnGreen() 
{
	master1.visual (xgui::modes::rgb_green | xgui::modes::reverse);
}


void CXDlg::OnBlue() 
{
	master1.visual (xgui::modes::rgb_blue | xgui::modes::reverse);
}


void CXDlg::OnHue() 
{
	master1.visual (xgui::modes::hsv_hue | xgui::modes::reverse);
}


void CXDlg::OnSat() 
{
	master1.visual (xgui::modes::hsv_sat | xgui::modes::reverse);
}


void CXDlg::OnValue() 
{
	master1.visual (xgui::modes::hsv_value | xgui::modes::reverse);
}


void CXDlg::OnHlsHue() 
{
	master1.visual (xgui::modes::hls_hue | xgui::modes::reverse);
}


void CXDlg::OnHlsLight() 
{
	master1.visual (xgui::modes::hls_light | xgui::modes::reverse);
}


void CXDlg::OnHlsSat() 
{
	master1.visual (xgui::modes::hls_sat | xgui::modes::reverse);
}


void CXDlg::OnRgb() 
{
	master2.visual (xgui::modes::rgb_red);
	m_wndComp1.SetWindowText ("R");
	m_wndComp2.SetWindowText ("G");
	m_wndComp3.SetWindowText ("B");
}


void CXDlg::OnHsv() 
{
	master2.visual (xgui::modes::hsv_hue);
	m_wndComp1.SetWindowText ("H");
	m_wndComp2.SetWindowText ("S");
	m_wndComp3.SetWindowText ("V");
}


void CXDlg::OnHls() 
{
	master2.visual (xgui::modes::hls_hue);
	m_wndComp1.SetWindowText ("H");
	m_wndComp2.SetWindowText ("L");
	m_wndComp3.SetWindowText ("S");
}


BOOL CXDlg::OnNotify (WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	LPNMHDR	lpnmhdr = (LPNMHDR) lParam;
	static char	buff [10];

	if (lpnmhdr->idFrom == IDC_CONTROLLER1)
	{
		if (m_wndLinkBoth.GetCheck ())
			master2.color (master1.color ());
	}
	else if (lpnmhdr->idFrom == IDC_CONTROLLER2)
	{
		if (m_wndLinkBoth.GetCheck ())
			master1.color (master2.color ());
	}

	// edit box updated to 2nd control
	if (m_wndLinkBoth.GetCheck () ||
		lpnmhdr->idFrom == IDC_CONTROLLER2)
	{
		COLORREF	c = master2.color ();
		sprintf (buff, "%02X %02X %02X", GetRValue (c), GetGValue (c), GetBValue (c));
		m_wndColor.SetWindowText (buff);
	}
	
	return CDialog::OnNotify(wParam, lParam, pResult);
}

void CXDlg::OnWebPalette() 
{
	master1.install_palette (
		(m_wndWebColors.GetCheck () ? xgui::wrapper::web : xgui::wrapper::none));
}
