// xgui 0.0.4 / 2002-08-07
//	base.cpp
//
//	http://606u.dir.bg/
//	606u@dir.bg

#include "_p.h"

#include "slider.h"
#include "picker.h"
#include "well.h"
#include "controller.h"



namespace xgui {


const char *base::class_name = "";


base::base ()
{
	DBG_HWND_INIT;
	tracking = false;
	hwnd = NULL;
	master = NULL;
	palette = NULL;
}


base::~base ()
{
	// controller owns the palette
	if (palette)
		palette = NULL;
}


bool
base::setup (
	IN HWND fresh_hwnd,
	IN LPCREATESTRUCT pcs)
{
	hwnd = fresh_hwnd;
	style = pcs->style;
	return (base::size_changed (pcs->cx, pcs->cy));
}


bool
base::hit_test (
	IN short /* x */,
	IN short /* y */) const
{
	return (true);
}


LRESULT
base::input_filter (void) const
{
	// control wants arrow keys only; override to change
	return (DLGC_WANTARROWS);
}


void
base::mouse_down (
	IN enum mouse_buttons button,
	IN short x,
	IN short y,
	IN int modifiers)
{
	POINT	pt = { x, y };

	SetFocus (hwnd);
	if (button == button_left && PtInRect (&interaction_area, pt))
	{
		SetCapture (hwnd);
		tracking = true;
		mouse_move (x, y, modifiers);
	}
}


void
base::mouse_up (
	IN enum mouse_buttons button,
	IN short /* x */,
	IN short /* y */,
	IN int /* modifiers */)
{
	if (button == button_left && tracking)
	{
		ReleaseCapture ();
		tracking = false;
	}
}


void
base::focused (void)
{
	InvalidateRect (hwnd, NULL, FALSE);
}


void
base::blurred (void)
{
	InvalidateRect (hwnd, NULL, FALSE);
}


bool
base::size_changed (
	IN int hsize,
	IN int vsize)
{
	// cannot compare new size with the old one,
	//	because size_changed is called by setup method, also
	SetRect (&frame, 0, 0, hsize, vsize);
	SetRect (&interaction_area, 2, 2, hsize - 3, vsize - 3);
	InvalidateRect (hwnd, NULL, FALSE);
	return (true);
}


void
base::display_settings_changed (void)
{
	InvalidateRect (hwnd, NULL, FALSE);
}


LRESULT
base::control_message (
	IN enum control_codes message,
	IN WPARAM /* wparam */,
	IN LPARAM lparam)
{
	switch (message)
	{
	case	messages::master_attach:
		master = (HWND) lparam;
		return (1);

	case	messages::master_detach:
		master = NULL;
		return (1);

	case	messages::palette_attach:
		// attach palette and request redraw
		palette = (xgui::palette *) lparam;
		InvalidateRect (hwnd, NULL, FALSE);
		return (1);

#if	defined (_DEBUG)
	case	messages::debug_window_attach:
		debug_window = (HWND) lparam;
		return (1);
#endif
	}
	return (0);
}


LRESULT
base::notify_parent (
	IN UINT code)
{
	UINT	control_id;
	HWND	parent_window;
	NMHDR	message;

	ASSERT (hwnd != NULL);

	control_id = GetDlgCtrlID (hwnd);
	if (control_id == 0)
		// failed to retrieve control's id
		return (-1);

	// setup structure
	message.code = code;
	message.hwndFrom = hwnd;
	message.idFrom = control_id;

	if (master != NULL)
		// send message as notification to the controller window
		return (SendMessage (master, xgui::messages::notification, control_id, (LPARAM) &message));

	parent_window = GetParent (hwnd);
	if (parent_window != NULL)
		// send WM_NOTIFY message to the parent window
		return (SendMessage (parent_window, WM_NOTIFY, control_id, (LPARAM) &message));

	return (-1);
}


#if	defined (_DEBUG)
void
base::debug_state (
	IN const char *format, ...)
{
	char	buffer [1024];
	va_list	va;

	va_start (va, format);
	vsprintf (buffer, format, va);
	SetWindowText (debug_window, buffer);
}
#endif


} // xgui namespace
