// xgui 0.0.4 / 2002-08-07
//	base.h
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_base_h
#define	_base_h

#include "palette.h"



#if	defined (_DEBUG)
#	define	DBG_HWND				HWND	debug_window;
#	define	DBG_HWND_INIT			debug_window = NULL
#	define	DBG_HWND_ATTACH_CM		debug_window_attach,
#	define	DBG_HWND_ATTACH(c,w)	::SendMessage (c, xgui::messages::debug_window_attach, 0, (LPARAM) w)
#else
#	define	DBG_HWND
#	define	DBG_HWND_INIT			NULL
#	define	DBG_HWND_ATTACH_CM
#	define	DBG_HWND_ATTACH(c,w)
#endif


namespace xgui {


class	base
{
public:
	base ();
	virtual	~base () = 0;

public:
	// register/unregister class
	static bool register_class (
		IN HINSTANCE library_instance); // = 0

	static bool unregister_class (
		IN HINSTANCE library_instance); // = 0

	// sets-up control instance
	virtual bool setup (
		IN HWND new_hwnd,
		IN LPCREATESTRUCT pcs);

	// returns control info to the system
	virtual bool hit_test (
		IN short x,
		IN short y) const;

	virtual LRESULT input_filter (void) const;

	// user interaction handlers
	enum mouse_buttons
	{
		button_left,
		button_right,
		button_middle
	};

	virtual void mouse_move (
		IN short x,
		IN short y,
		IN int modifiers) = 0;

	virtual void mouse_down (
		IN enum mouse_buttons button,
		IN short x,
		IN short y,
		IN int modifiers);

	virtual void mouse_up (
		IN enum mouse_buttons button,
		IN short x,
		IN short y,
		IN int modifiers);

	virtual void mouse_wheel (
		IN short delta) = 0;

	virtual void key_down (
		IN int key_code,
		IN int modifiers) = 0;

	virtual void focused (void);

	virtual void blurred (void);

	// painting methods
	virtual void paint (
		IN LPPAINTSTRUCT pnt) = 0;

	virtual void display_settings_changed (void);

	// called, when window size has changed
	virtual bool size_changed (
		IN int hsize,
		IN int vsize);

	// control messages handled by default method: ...
	virtual LRESULT	control_message (
		IN enum control_codes message,
		IN WPARAM wparam,
		IN LPARAM lparam);

	// parent notification methods
	virtual LRESULT	notify_parent (
		IN UINT code);

protected:
	HWND	hwnd;				// control's window handle
	LONG	style;				// copy of window's style
	RECT	frame;				// control's frame (bounding box)
	RECT	interaction_area;	// area, where mouse-drags will be traced (client area)
	bool	tracking;			// whether mouse is being tracked (drag)
	HWND	master;				// master (controller) window handle

	palette	*palette;			// palette control is attached to or NULL

public:
	virtual const char	*window_class_name (void) const { return (class_name); };

	// registered window class information
	static const char	*class_name;
	static WNDCLASS		window_class;
	static ATOM			class_atom;

#if	defined (_DEBUG)
	void	debug_state (const char *format, ...);
	HWND	debug_window;
#else
	// no debug info for the release mode
	inline void debug_state (const char* /* format */, ...) { };
#endif
};


} // xgui namespace


#endif	// _base_h
