// xgui 0.0.4 / 2002-08-07
//	controller.cpp
//
//	http://606u.dir.bg/
//	606u@dir.bg

#include "_p.h"

#include "controller.h"

#include "resource.h"


namespace xgui {


// controller's static members initialization
const char	*controller::class_name = "xgui_controller";
WNDCLASS	controller::window_class = { 0 };
ATOM		controller::class_atom = 0;


controller::controller (void)
	: base ()
{
	// initialize
	visual_mode = -1;
	layout_mode = -1;
	dont_interrupt = false;
	// base initializes palette to NULL
}


controller::~controller ()
{
	if (palette)
		delete palette, palette = NULL;
}


bool
controller::register_class (
	IN HINSTANCE library_instance)
{
	setup_wndclass (window_class, library_instance, class_name);
	return (wndclass::reg (class_name, &window_class, &class_atom));
}


bool
controller::unregister_class (
	IN HINSTANCE library_instance)
{
	return (wndclass::unreg (library_instance, class_name));
}


bool
controller::setup (
	IN HWND hwnd,
	IN LPCREATESTRUCT pcs)
{
	if (base::setup (hwnd, pcs))
	{
		return (true);
	}

	return (false);
}


LRESULT
controller::control_message (
	IN enum control_codes message,
	IN WPARAM wparam,
	IN LPARAM lparam)
{
	LRESULT		result;

	// ask base class first
	result = base::control_message (message, wparam, lparam);
	if (result)
		return (result);

	switch (message)
	{
	case	messages::notification:
		// attached controls are sending a notification code
		return (notification_message ((LPNMHDR) lparam));

	case	messages::palette_set:
		install_palette (
			(WORD) lparam);	// palette id
		return (1);

	case	messages::layout_get:	return (layout ());
	case	messages::layout_set:	layout (lparam); break;
	case	messages::visual_get:	return (visual ());
	case	messages::visual_set:	visual (lparam); break;
	case	messages::slave_set:	slave (wparam, (HWND) lparam); break;
	case	messages::color_get:	return (color ());
	case	messages::color_set:	color (lparam); break;
	default:
		debug_message ("controller::control_message: unknown - m %d, w %d, l %d.", message, wparam, lparam);
		break;
	}

	InvalidateRect (hwnd, NULL, FALSE);
	return (0);
}


LRESULT
controller::notification_message (
	IN LPNMHDR message)
{
	if (dont_interrupt)
		return (0);

	switch (layout_mode)
	{
	case	layout_picker:	return (notification_message_as_picker (message));
	case	layout_sliders:	return (notification_message_as_sliders (message));
	}
	return (0);
}


void
controller::layout (
	IN int value)
{
	if (layout_mode == value)
		return;

	debug_state ("layout_set = %x", value);

	switch (value)
	{
	case	layout_picker:	layout_as_picker (); break;
	case	layout_sliders:	layout_as_sliders (); break;
	}
}


void
controller::visual (
	IN int value)
{
	if (visual_mode == value)
		return;

	debug_state ("visual_set = %x", value);

	switch (layout_mode)
	{
	case	layout_picker:	visual_as_picker (value); break;
	case	layout_sliders:	visual_as_sliders (value); break;
	}
}


COLORREF
controller::color (void) const
{
	COLORREF	c;

	switch (layout_mode)
	{
	case	layout_picker:	c = color_as_picker (); break;
	case	layout_sliders:	c = color_as_sliders (); break;
	default:	ASSERT (FALSE); c = RGB (0, 0, 0);
	}

	// match colors to palette if installed
	if (palette)
		c = palette->match_rgb (c);

	return (c);
}


void
controller::color (
	IN COLORREF value,
	IN OPTIONAL bool force_change)	// = false
{
	if (!force_change && color () == value)
		// fixes the bugs with "sticky" sliders and "jumpy" behaviour
		return;

	switch (layout_mode)
	{
	case	layout_picker:	color_as_picker (value); break;
	case	layout_sliders:	color_as_sliders (value); break;
	}
	// replaced well.color (value), because
	// if palette is installed, color will be changed
	well.color (color ());
}


void
controller::slave (
	IN int index,
	IN HWND window)
{
	switch (layout_mode)
	{
	case	layout_picker:	slave_as_picker (index, window); break;
	case	layout_sliders:	slave_as_sliders (index, window); break;
	}
}


void
controller::install_palette (
	IN WORD palette_id)
{
	COLORREF	old_color = color ();

	// clean-up old one
	if (palette)
		delete palette, palette = NULL;

	// palette_id = 0 means remove palette
	if (palette_id != 0)
		palette = new xgui::palette (palette_id);

	switch (layout_mode)
	{
	case	layout_picker:	palette_as_picker (); break;
	case	layout_sliders:	palette_as_sliders (); break;
	}

	// update color when palette is switched
	COLORREF	new_color = color ();
	color (old_color);
	color (new_color);
}


} // xgui namespace
