// xgui 0.0.4 / 2002-08-07
//	controller.h
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_controller_h
#define	_controller_h

#include "base.h"
#include "xgui.h"

#include "picker_wrapper.inl"
#include "slider_wrapper.inl"
#include "well_wrapper.inl"



namespace xgui {

class controller : public base
{
public:
	controller (void);
	~controller ();

	// register and unregister class methods
	static bool	register_class (
		IN HINSTANCE library_instance);

	static bool	unregister_class (
		IN HINSTANCE library_instance);

	// initialization
	bool setup (
		IN HWND hwnd,
		IN LPCREATESTRUCT pcs);

	// user interaction methods
	void mouse_move (
		IN short /* x */,
		IN short /* y */,
		IN int /* modifiers */) { };

	void mouse_left_down (
		IN short /* x */,
		IN short /* y */,
		IN int /* modifiers */) { };

	void mouse_left_up (
		IN short /* x */,
		IN short /* y */,
		IN int /* modifiers */) { };

	void mouse_wheel (
		IN short /* delta */) { };

	void key_down (
		IN int /* key_code */,
		IN int /* modifiers */) { };

	// painting methods
	void paint (
		IN LPPAINTSTRUCT /* pnt */) { };

	void display_settings_changed (void) { };

	LRESULT	control_message (
		IN enum control_codes message,
		IN WPARAM wparam,
		IN LONG lparam);

	LRESULT	notification_message (
		IN LPNMHDR message);

	LRESULT notification_message_as_picker (
		IN LPNMHDR message);
	LRESULT notification_message_as_sliders (
		IN LPNMHDR message);

	enum layouts
	{
		layout_picker = 0,
		layout_sliders = 1
	};

private:
	// get/set layout (could be picker or sliders)
	inline int layout (void) const { return (layout_mode); };
	void layout (
		IN int value);
	void layout_as_picker (void);
	void layout_as_sliders (void);

	// get/set visual mode
	inline int visual (void) const { return (visual_mode); };
	void visual (
		IN int value);
	void visual_as_picker (
		IN int value);
	void visual_as_sliders (
		IN int value);

	// get/set color
	COLORREF color (void) const;
	COLORREF color_as_picker (void) const;
	COLORREF color_as_sliders (void) const;
	void color (
		IN COLORREF value,
		IN OPTIONAL bool force_change = false);	// if false, no change if old = new
	void color_as_picker (
		IN COLORREF value);
	void color_as_sliders (
		IN COLORREF value);

	// get/set slave control (index depends on the current mode)
	void slave (
		IN int index,
		IN HWND window);
	void slave_as_picker (
		IN int index,
		IN HWND window);
	void slave_as_sliders (
		IN int index,
		IN HWND window);

	// install (web) palette
	void install_palette (
		IN WORD palette_id);
	void palette_as_picker (void);
	void palette_as_sliders (void);

private:
	int		visual_mode;		// xgui::modes::visual - "xgui_constants.h"
	int		layout_mode;		// layouts enum
	bool	dont_interrupt;		// controller is in a middle of something and doesn't process notification messages

	wrapper::picker	picker;
	wrapper::slider	slider;
	wrapper::well	well;
	wrapper::slider	sliders [4];

public:
	virtual const char *window_class_name (void) const { return (class_name); };

	// registered window class information
	static const char	*class_name;
	static WNDCLASS		window_class;
	static ATOM			class_atom;
};

} // xgui namespace



#endif	// _controller_h
