// xgui 0.0.4 / 2002-08-07
//	controller_picker.cpp
//
//	http://606u.dir.bg/
//	606u@dir.bg

#include "_p.h"

#include "controller.h"


namespace xgui {


LRESULT
controller::notification_message_as_picker (
	IN LPNMHDR message)
{
	// picker sent notification message
	if (message->hwndFrom == picker.window_handle ())
	{
		switch (message->code & messages::mask)
		{
		case	messages::drag:
		case	messages::release:
			// consult xgui_constants.h about components directions
			//	when working with different color spaces
			switch (visual_mode & modes::mask)
			{
			case	modes::rgb_red:
			case	modes::rgb_green:
				slider.component (0, picker.y_pos ());
				slider.component (1, picker.x_pos ());
				break;

			case	modes::rgb_blue:
				slider.component (0, picker.x_pos ());
				slider.component (1, picker.y_pos ());
				break;

			case	modes::hsv_hue:
			case	modes::hsv_sat:
			case	modes::hsv_value:
				slider.component (0, picker.x_pos ());
				slider.component (1, picker.y_pos ());
				break;

			case	modes::hls_hue:
				slider.component (0, picker.y_pos ());
				slider.component (1, picker.x_pos ());
				break;

			case	modes::hls_light:
			case	modes::hls_sat:
				slider.component (0, picker.x_pos ());
				slider.component (1, picker.y_pos ());
				break;
			}

			COLORREF	c = message->code & ~messages::mask;
			// match colors to palette if installed
			if (palette)
				c = palette->match_rgb (c);

			well.color (c);
			notify_parent (c);

			debug_state ("picker_move = %x", message->code);
			break;
		}
	}

	// slider sent notification message
	else if (message->hwndFrom == slider.window_handle ())
	{
		switch (message->code & messages::mask)
		{
		case	messages::drag:
		case	messages::release:
			picker.component (slider.position ());
			break;
		}
		debug_state ("slider_move = %x", message->code);
	}
	return (0);
}


void
controller::layout_as_picker (void)
{
	// initialize if neccessary
	well.detach ();
	picker.detach ();
	slider.detach ();

	layout_mode = layout_picker;
}


void
controller::visual_as_picker (
	IN int value)
{
	COLORREF	old_color;

	visual_mode = value;
	old_color = picker.color ();
	picker.visual (visual_mode);
	slider.visual (visual_mode);

	// update both - picker and slider
	picker.color (old_color);
	slider.position (picker.component ());
}


COLORREF
controller::color_as_picker (void) const
{
	return (picker.color ());
}


void
controller::color_as_picker (
	IN COLORREF value)
{
	// update both - picker and slider
	picker.color (value);
	slider.position (picker.component ());
}


void
controller::slave_as_picker (
	IN int index,
	IN HWND window)
{
	switch (index)
	{
	case	0:
		well.attach (window);
		well.master_attach (hwnd);
		break;

	case	1:
		picker.attach (window);
		picker.master_attach (hwnd);
		break;

	case	2:
		slider.attach (window);
		slider.master_attach (hwnd);
		break;
	}
}


void
controller::palette_as_picker (void)
{
	if (picker.attached ())
		SendMessage (
			picker.window_handle (),
			messages::palette_attach,
			0,
			(LPARAM) palette);
	if (slider.attached ())
		SendMessage (
			slider.window_handle (),
			messages::palette_attach,
			0,
			(LPARAM) palette);
}


} // xgui namespace
