// xgui 0.0.4 / 2002-08-07
//	controller_sliders.cpp
//
//	http://606u.dir.bg/
//	606u@dir.bg

#include "_p.h"

#include "controller.h"


namespace xgui {


LRESULT
controller::notification_message_as_sliders (
	IN LPNMHDR message)
{
	int	i;
	COLORREF	c;

	int	visual;
	int	pos;

	// the meaning of update matrixes:
	//	when a slider position is changed OTHER sliders in the group should have
	//	one of their components updated (component matching the changed slider);
	//	following matrix contains 2 pairs of slider index and component index
	//	to be updated when the slider to the corresponding color component is changed
	//	(2 pairs, since there are 3 sliders and only 2 should be updated on change)
	//	line 1 reads:
	//	when red is changed update 1st component of 2nd slider and
	//	1st component of 3rd slider...
	const int update_matrix [modes::max][max::components - 1][2] =
	{
		{ { 1, 0 }, { 2, 0 } },	// rgb red
		{ { 0, 0 }, { 2, 1 } },	// rgb green
		{ { 0, 1 }, { 1, 1 } },	// rgb blue
		{ { 1, 0 }, { 2, 0 } }, // hsv hue
		{ { 0, 0 }, { 2, 1 } },	// hsv sat
		{ { 0, 1 }, { 1, 1 } },	// hsv value
		{ { 1, 0 }, { 2, 0 } }, // hls hue
		{ { 0, 0 }, { 2, 1 } },	// hls light
		{ { 0, 1 }, { 1, 1 } },	// hls sat
	};

	switch (message->code & messages::mask)
	{
	case	messages::drag:
	case	messages::release:
		// get visual (color component) changed and its new value
		visual = 0;
		for (i=0; i<max::components; i++)
			if (sliders [i].attached () &&
				sliders [i].window_handle () == message->hwndFrom)
			{
				visual = sliders [i].visual ();
				break;
			}
		pos = message->code & ~messages::mask;

		for (i=0; i<max::components - 1; i++)
			sliders [(update_matrix [visual][i][0])].component (
				update_matrix [visual][i][1], pos);

		c = color_as_sliders ();

		// match colors to palette if installed
		if (palette)
			c = palette->match_rgb (c);

		well.color (c);
		notify_parent (c);

		debug_state ("slider_move = %x", message->code);

		break;
	}
	return (0);
}


void
controller::layout_as_sliders (void)
{
	// initialize if neccessary
	sliders [0].detach ();
	sliders [1].detach ();
	sliders [2].detach ();
	sliders [3].detach ();

	layout_mode = layout_sliders;
}


void
controller::visual_as_sliders (
	IN int value)
{
	COLORREF	old_color;

	// skip first time - when visual_mode will not be updated yet
	old_color = (visual_mode != -1 ? color () : 0);
	visual_mode = value;
	switch (visual_mode & modes::mask)
	{
	case	modes::rgb_red:
	case	modes::rgb_green:
	case	modes::rgb_blue:
		sliders [0].visual (modes::rgb_red);
		sliders [1].visual (modes::rgb_green);
		sliders [2].visual (modes::rgb_blue);
		break;

	case	modes::hsv_hue:
	case	modes::hsv_sat:
	case	modes::hsv_value:
		sliders [0].visual (modes::hsv_hue);
		sliders [1].visual (modes::hsv_sat);
		sliders [2].visual (modes::hsv_value);
		break;

	case	modes::hls_hue:
	case	modes::hls_light:
	case	modes::hls_sat:
		sliders [0].visual (modes::hls_hue);
		sliders [1].visual (modes::hls_light);
		sliders [2].visual (modes::hls_sat);
		break;
	
	default:
		ASSERT (FALSE);
	}
	color (old_color);
}


COLORREF
controller::color_as_sliders (void) const
{
	int	comps [4];
	COLORREF	c;

	// there are always at least 3 sliders (4 for CMYK mode only)
	comps [0] = sliders [0].position ();
	comps [1] = sliders [1].position ();
	comps [2] = sliders [2].position ();
	if (sliders [3].attached ())
		comps [3] = sliders [3].position ();

	switch (visual_mode & modes::mask)
	{
	case	modes::rgb_red:
	case	modes::rgb_green:
	case	modes::rgb_blue:
		c = RGB (comps [0], comps [1], comps [2]);
		break;

	case	modes::hsv_hue:
	case	modes::hsv_sat:
	case	modes::hsv_value:
		c = convert::hsv2rgb (
			(double) comps [0] / (double) scale::hsv_hue,
			(double) comps [1] / (double) scale::hsv_sat,
			(double) comps [2] / (double) scale::hsv_value);
		break;

	case	modes::hls_hue:
	case	modes::hls_light:
	case	modes::hls_sat:
		c = convert::hls2rgb (
			(double) comps [0] / (double) scale::hls_hue,
			(double) comps [1] / (double) scale::hls_light,
			(double) comps [2] / (double) scale::hls_sat);
		break;

	default:
		ASSERT (FALSE);
		c = 0;
	}

	return (c);
}


void
controller::color_as_sliders (
	IN COLORREF value)
{
	double	h, l, s, v;
	int		r, g, b;
	int		hh, ll, ss, vv;

	// rgb decomposed
	r = GetRValue (value);
	g = GetGValue (value);
	b = GetBValue (value);

	switch (visual_mode & modes::mask)
	{
	case	modes::rgb_red:
	case	modes::rgb_green:
	case	modes::rgb_blue:
		sliders [0].position (r);
		sliders [0].component (0, g);
		sliders [0].component (1, b);

		sliders [1].position (g);
		sliders [1].component (0, r);
		sliders [1].component (1, b);

		sliders [2].position (b);
		sliders [2].component (0, r);
		sliders [2].component (1, g);
		break;

	case	modes::hsv_hue:
	case	modes::hsv_sat:
	case	modes::hsv_value:
		convert::rgb2hsv (
			// red, green and blue should be scaled to [0, 1]
			(double) r / (double) max::rgb_red,
			(double) g / (double) max::rgb_green,
			(double) b / (double) max::rgb_blue,
			&h, &s, &v);
		hh = (int) (h * scale::hsv_hue);
		ss = (int) (s * scale::hsv_sat);
		vv = (int) (v * scale::hsv_value);
		sliders [0].position (hh);
		sliders [0].component (0, ss);
		sliders [0].component (1, vv);

		sliders [1].position (ss);
		sliders [1].component (0, hh);
		sliders [1].component (1, vv);

		sliders [2].position (vv);
		sliders [2].component (0, hh);
		sliders [2].component (1, ss);
		break;

	case	modes::hls_hue:
	case	modes::hls_light:
	case	modes::hls_sat:
		convert::rgb2hls (
			// red, green and blue should be scaled to [0, 1]
			(double) r / (double) max::rgb_red,
			(double) g / (double) max::rgb_green,
			(double) b / (double) max::rgb_blue,
			&h, &l, &s);
		hh = (int) (h * scale::hls_hue);
		ll = (int) (l * scale::hls_light);
		ss = (int) (s * scale::hls_sat);
		sliders [0].position (hh);
		sliders [0].component (0, ll);
		sliders [0].component (1, ss);

		sliders [1].position (ll);
		sliders [1].component (0, hh);
		sliders [1].component (1, ss);

		sliders [2].position (ss);
		sliders [2].component (0, hh);
		sliders [2].component (1, ll);
		break;

	default:
		ASSERT (FALSE);
	}
}


void
controller::slave_as_sliders (
	IN int index,
	IN HWND window)
{
	if (index == 0)
	{
		well.attach (window);
		well.master_attach (hwnd);
	}
	else
	{
		sliders [index - 1].attach (window);
		sliders [index - 1].master_attach (hwnd);
	}
}


void
controller::palette_as_sliders (void)
{
	for (int i=0; i<(sizeof (sliders)/sizeof (sliders [0])); i++)
		if (sliders [i].attached ())
			SendMessage (
				sliders [i].window_handle (),
				messages::palette_attach,
				0,
				(LPARAM) palette);

}


} // xgui namespace
