// xgui 0.0.4 / 2002-08-07
//	controller_wrapper.inl
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_controller_wrapper_h
#define	_controller_wrapper_h

#include "controller.h"

#include "picker_wrapper.inl"
#include "slider_wrapper.inl"
#include "well_wrapper.inl"


namespace xgui {

namespace wrapper {

enum palettes
{
	none = 0,
	named_web_colors = -1,
	web = 1001,
	winos = 1002,
	macos = 1003
};

class	controller
{
public:
	inline controller (void);
	inline controller (
		IN HWND window);

	// attaches class instance to a control
	inline void	attach (
		IN HWND window);

	// detaches control from the class instance
	inline void	detach (void);

	// returns whether class instance is currently attached to a control
	inline bool	attached (void) const;

	// returns window handle for control class is attached with
	inline HWND	window_handle (void) const;

	// attaches control to a master (controller)
	inline void	master_attach (
		IN HWND window);

public:
	// sets-up controller to manage a picker and a slider
	inline void	setup_as_picker (
		IN HWND well,
		IN HWND picker,
		IN HWND slider);

	// sets-up controller to manage a group of 3 (or 4) sliders
	inline void	setup_as_sliders (
		IN HWND well,
		IN HWND slider1,
		IN HWND slider2,
		IN HWND slider3,
		OPTIONAL IN HWND slider4 = NULL);

	// set/get controller's current layout bit mask (xgui::controller::layouts - "controller.h")
	inline int layout (void) const;
	inline void	layout (
		IN int value);

	// get/set controller's visual mode (xgui::modes::visual - "xgui_constants.h")
	inline int visual (void) const;
	inline void	visual (
		IN int value);

	// get/set controller's color
	inline COLORREF	color (void) const;
	inline void	color (
		IN COLORREF value);

	// install or remove a palette
	inline void install_palette (
		IN palettes palette);

private:
	HWND	hwnd;
};


inline controller::controller (void)
{
	hwnd = NULL;
}


inline controller::controller (
	IN HWND window)
	: hwnd (window)
{
}


inline void
controller::attach (
	IN HWND window)
{
	hwnd = window;
}


inline void
controller::detach (void)
{
	hwnd = NULL;
}


inline bool
controller::attached (void) const
{
	return (hwnd != NULL);
}


inline HWND
controller::window_handle (void) const
{
	return (hwnd);
}


inline void
controller::master_attach (
	IN HWND window)
{
	SendMessage (hwnd, xgui::messages::master_attach, 0, (LPARAM) window);
}


inline void
controller::setup_as_picker (
	IN HWND well,
	IN HWND picker,
	IN HWND slider)
{
	layout (xgui::controller::layout_picker);
	visual (xgui::modes::rgb_red);	// default
	SendMessage (hwnd, xgui::messages::slave_set, 0, (LPARAM) well);
	SendMessage (hwnd, xgui::messages::slave_set, 1, (LPARAM) picker);
	SendMessage (hwnd, xgui::messages::slave_set, 2, (LPARAM) slider);
}

inline void
controller::setup_as_sliders (
	IN HWND well,
	IN HWND slider1,
	IN HWND slider2,
	IN HWND slider3,
	OPTIONAL IN HWND slider4) // = 0
{
	layout (xgui::controller::layout_sliders);
	visual (xgui::modes::rgb_red);	// default
	SendMessage (hwnd, xgui::messages::slave_set, 0, (LPARAM) well);
	SendMessage (hwnd, xgui::messages::slave_set, 1, (LPARAM) slider1);
	SendMessage (hwnd, xgui::messages::slave_set, 2, (LPARAM) slider2);
	SendMessage (hwnd, xgui::messages::slave_set, 3, (LPARAM) slider3);
	SendMessage (hwnd, xgui::messages::slave_set, 4, (LPARAM) slider4);
}


inline int
controller::layout (void) const
{
	return ((int) SendMessage (hwnd, xgui::messages::layout_get, 0, 0));
}


inline void
controller::layout (
	IN int value)
{
	SendMessage (hwnd, xgui::messages::layout_set, 0, value);
}


inline int
controller::visual (void) const
{
	return ((int) SendMessage (hwnd, xgui::messages::visual_get, 0, 0));
}


inline void
controller::visual (
	IN int value)
{
	SendMessage (hwnd, xgui::messages::visual_set, 0, value);
}


inline COLORREF
controller::color (void) const
{
	return ((COLORREF) SendMessage (hwnd, xgui::messages::color_get, 0, 0));
}


inline void
controller::color (
	IN COLORREF value)
{
	SendMessage (hwnd, xgui::messages::color_set, 0, (LPARAM) value);
}


inline void
controller::install_palette (
	IN palettes palette)
{
	SendMessage (hwnd, xgui::messages::palette_set, 0, (LPARAM) palette);
}


} // wrapper namespace

} // xgui namespace

#endif	// _controller_wrapper_h
