// xgui 0.0.4 / 2002-08-07
//	gradient.cpp
//
//	http://606u.dir.bg/
//	606u@dir.bg

#include "_p.h"

#include "gradient.h"


namespace xgui {


// gradient's static members initialization
const char	*gradient::class_name = "xgui_gradient";
WNDCLASS	gradient::window_class = { 0 };
ATOM		gradient::class_atom = 0;



gradient::gradient (void)
{
	visual_mode = -1;
	layout_mode = -1;
	selected_anchor = -1;

	bmp_handle = NULL;
	row_buffer = NULL;

	num_anchors = 0;
	anchors = NULL;
	size = 1024;

	add_anchor (1, 0 * size / 5, RGB (0, 128, 255));
	add_anchor (2, 1 * size / 5, RGB (0, 64, 192));
	add_anchor (3, 2 * size / 5, RGB (255, 255, 255));
	add_anchor (4, 3 * size / 5, RGB (0, 0, 0));
	add_anchor (5, 4 * size / 5, RGB (0, 64, 192));
	add_anchor (6, 5 * size / 5, RGB (0, 64, 255));
}


gradient::~gradient ()
{
	if (anchors != NULL)
		delete [] anchors;
}


bool
gradient::register_class (
	IN HINSTANCE library_instance)
{
	setup_wndclass (window_class, library_instance, class_name);
	return (wndclass::reg (class_name, &window_class, &class_atom));
}


bool
gradient::unregister_class (
	IN HINSTANCE library_instance)
{
	return (wndclass::unreg (library_instance, class_name));
}


bool
gradient::setup (
	IN HWND hwnd,
	IN LPCREATESTRUCT pcs)
{
	if (base::setup (hwnd, pcs))
	{
		// no default mode; should be set using window style
		layout (pcs->style & 0xFF00);
		visual (pcs->style & 0x00FF);

		// get triangle size from bits 9 to 12 (and add 4)
		triangle_size = ((pcs->style & 0x0F00) >> 8) + 4;

		return (size_changed (pcs->cx, pcs->cy));
	}

	return (false);
}


void
gradient::mouse_move (
	IN short x,
	IN short y,
	IN int /* modifiers */)
{
	int	new_pos;

	// giveup if no selection; drag selection otherwise
	if (selected_anchor == -1 || !tracking)
		return;

	// first and last anchors could not be moved
	if (selected_anchor == 0 || selected_anchor == num_anchors - 1)
		return;

	if (layout_mode & layout_horizontal)
		new_pos = x - triangle_size;
	else // if (layout_mode & layout_vetical)
		new_pos = y - triangle_size;

	// make sure minimal distance between two sequential anchors is preserved
	in_range (
		new_pos,
		anchor_in_pixels (selected_anchor - 1) + 2 * triangle_size + 1,
		anchor_in_pixels (selected_anchor + 1) - 2 * triangle_size + 1);
	
	if (layout_mode & layout_horizontal)
		new_pos = (new_pos * size) / (blend_rect.right - blend_rect.left);
	else
		new_pos = ((new_pos - blend_rect.top) * size) / (blend_rect.bottom - blend_rect.top);
	anchors [selected_anchor].position = new_pos;

	repaint ();
}


void
gradient::mouse_down (
	IN enum mouse_buttons button,
	IN short x,
	IN short y,
	IN int modifiers)
{
	double	d;
	int		n;
	int		i;

	// locate clicked anchor or set selection to none
	selected_anchor = -1;
	for (i=0; i<num_anchors && selected_anchor == -1; i++)
	{
		d = (double) anchors [i].position / size;
		if (layout_mode & layout_horizontal)
		{
			n = (int) (blend_rect.left + d * (blend_rect.right - blend_rect.left));
			if (x >= n - triangle_size && x <= n + triangle_size)
				selected_anchor = i;
		}
		else // if (layout_mode & layout_vertical)
		{
			n = (int) (blend_rect.top + d * (blend_rect.bottom - blend_rect.top));
			if (y >= n - triangle_size && y <= n + triangle_size)
				selected_anchor = i;
		}
	}

	repaint ();

	// should not call following method above, since mouse_down calls mouse_move,
	//	because selected_anchor will not be initialized yet
	base::mouse_down (button, x, y, modifiers);
}


void
gradient::paint (
	IN LPPAINTSTRUCT pnt)
{
	HDC		hdc;

	// create compatible DC
	hdc = CreateCompatibleDC (pnt->hdc);
	if (hdc != NULL)
	{
		HBRUSH	bg_fill;
		COLORREF	tr_fill;

		SelectObject (hdc, bmp_handle);

		// paint control's background
		bg_fill = CreateSolidBrush (GetSysColor (COLOR_BTNFACE));
		SelectObject (hdc, GetStockObject (NULL_PEN));
		SelectObject (hdc, bg_fill);
		Rectangle (hdc, 0, 0, frame.right - frame.left + 1, frame.bottom - frame.top + 1);
		SelectObject (hdc, GetStockObject (WHITE_BRUSH));
		DeleteObject (bg_fill);

		// paint blend and frame
		panel::draw (hdc, &panel_rect,
			panel::sunken | panel::blackbox);
		GdiFlush ();
		blend ();

		for (int i=0; i<num_anchors; i++)
		{
			// highlight selected anchor
			if (selected_anchor == i)
				tr_fill = GetSysColor (COLOR_HIGHLIGHT);
			else
				tr_fill = GetSysColor (COLOR_WINDOW);

			if (layout_mode & layout_horizontal)
			{
				// horizontal slider
				int		x;

				x = anchor_in_pixels (i);

				if (layout_mode & layout_tr_top)
				{
					triangle::draw (hdc, blend_rect.left + x, panel_rect.top - 2,
						triangle::bottom, triangle_size,
						GetSysColor (COLOR_WINDOWTEXT), tr_fill);
					box::draw (hdc,
						blend_rect.left + x - triangle_size + 1,
						panel_rect.top - 2 - triangle_size - 1 - triangle_size * 2,
						triangle_size * 2 - 1,
						GetSysColor (COLOR_WINDOWTEXT), anchors [i].color);
				}
				if (layout_mode & layout_tr_bottom)
				{
					triangle::draw (hdc, blend_rect.left + x, panel_rect.bottom + 2,
						triangle::top, triangle_size,
						GetSysColor (COLOR_WINDOWTEXT), tr_fill);
					box::draw (hdc,
						blend_rect.left + x - triangle_size + 1,
						panel_rect.bottom + 2 + triangle_size + 1,
						triangle_size * 2 - 1,
						GetSysColor (COLOR_WINDOWTEXT), anchors [i].color);
				}
			}
			else // if (layout_mode & layout_vertical)
			{
				// vertical slider
				int	y;

				y = anchor_in_pixels (i);

				if (layout_mode & layout_tr_left)
					triangle::draw (hdc, panel_rect.left - 2, blend_rect.top + y,
						triangle::right, triangle_size,
						GetSysColor (COLOR_WINDOWTEXT), tr_fill);
				if (layout_mode & layout_tr_right)
					triangle::draw (hdc, panel_rect.right + 2, blend_rect.top + y,
						triangle::left, triangle_size,
						GetSysColor (COLOR_WINDOWTEXT), tr_fill);
			}
		}

		// paint a focus rectangle if necessary
		if (GetFocus () == hwnd)
			DrawFocusRect (hdc, &frame);

		// bitblt and delete cache DC
		GdiFlush ();
		BitBlt (pnt->hdc, 0, 0,
			frame.right - frame.left, frame.bottom - frame.top, hdc, 0, 0, SRCCOPY);
		DeleteDC (hdc);
	}
}


bool
gradient::add_anchor (
	IN int id,
	IN int position,
	IN COLORREF color)
{
	if (anchors == NULL)
		// initialize anchors buffer
		anchors = new anchor [ANCHORS_GROW_COUNT];
	else if (num_anchors == allocated_anchors)
	{
		// grow anchors buffer
		anchor	*temp = new anchor [allocated_anchors + ANCHORS_GROW_COUNT];
		if (temp != NULL)
		{
			memcpy (
				temp,
				anchors,
				sizeof (anchor) * num_anchors);
			delete [] anchors;
			anchors = temp;
			allocated_anchors += ANCHORS_GROW_COUNT;
		}
		else
			return (false);
	}

	// add new
	anchors [num_anchors].id = id;
	anchors [num_anchors].position = position;
	anchors [num_anchors].color = color;
	num_anchors++;

	return (true);
}


bool
gradient::remove_anchor (
	IN int id)
{
	// find an anchor by its id
	for (int i=0; i<num_anchors; i++)
		if (anchors [i].id == id)
		{
			// shift from next to the last to the front
			memmove (
				anchors + i,
				anchors + i + 1,
				sizeof (anchor) * (num_anchors - i));
			num_anchors--;
			return (true);
		}
	return (false);
}


int
gradient::anchor_in_pixels (
	IN int index) const
{
	if (layout_mode & layout_horizontal)
		return (((blend_rect.right - blend_rect.left) * anchors [index].position) / size);
	else // if (layout_mode & layout_vertical)
	{
		if (visual_mode & modes::reverse)
			return (((blend_rect.bottom - blend_rect.top) * (size - anchors [index].position)) / size);
		else
			return (((blend_rect.bottom - blend_rect.top) * anchors [index].position) / size);
	}
}


void
gradient::layout (
	IN int value)
{
	layout_mode = value;
	repaint ();
}


void
gradient::visual (
	IN int value)
{
	if ((value & modes::mask) < 0 ||
		(value & modes::mask) > xgui::modes::max)
		// invalid mode
		return;

	visual_mode = value;
	repaint ();
}


bool
gradient::size_changed (
	IN int hsize,
	IN int vsize)
{
	if (!base::size_changed (hsize, vsize))
		return (false);

	CopyRect (&panel_rect, &interaction_area);
	if (layout_mode & layout_horizontal)
	{
		// horizontal slider
		if (layout_mode & layout_tr_top)
			panel_rect.top += (triangle_size + 1 + triangle_size * 2 - 1 + 1);
		if (layout_mode & layout_tr_bottom)
			panel_rect.bottom -= (triangle_size + 1 + triangle_size * 2 - 1 + 1);
		InflateRect (&panel_rect, -(triangle_size - 3), 0);
	}
	else // if (layout_mode & layout_vertical)
	{
		// vertical slider
		if (layout_mode & layout_tr_left)
			panel_rect.left += (triangle_size + 1 + triangle_size * 2 - 1 + 1);
		if (layout_mode & layout_tr_right)
			panel_rect.right -= (triangle_size + 1 + triangle_size * 2 - 1 + 1);
		InflateRect (&panel_rect, 0, -(triangle_size - 3));
	}

	CopyRect (&blend_rect, &panel_rect);
	InflateRect (&blend_rect, -2, -2);

	if (layout_mode & layout_horizontal)
		row_buff_size = blend_rect.right - blend_rect.left + 1;
	else
		row_buff_size = blend_rect.bottom - blend_rect.top + 1;
	if (row_buffer)
		delete [] row_buffer;
	row_buffer = new DWORD [row_buff_size];
	if (row_buffer == NULL)
		return (false);

	// create cache bitmap
	bmp_info.bmiHeader.biSize = sizeof (BITMAPINFO);
	bmp_info.bmiHeader.biWidth = hsize;
	bmp_info.bmiHeader.biHeight = vsize;
	bmp_info.bmiHeader.biPlanes = 1;
	bmp_info.bmiHeader.biBitCount = 32;
	bmp_info.bmiHeader.biCompression = BI_RGB;
	bmp_info.bmiHeader.biSizeImage = hsize * vsize * 32 / 8;
	bmp_info.bmiHeader.biXPelsPerMeter =
		bmp_info.bmiHeader.biYPelsPerMeter = 72 * 2 * 1000;
	bmp_info.bmiHeader.biClrUsed = 0;
	bmp_info.bmiHeader.biClrImportant = 0;
	bmp_data = NULL;
	bmp_handle = CreateDIBSection (
		NULL, &bmp_info, DIB_RGB_COLORS, (void **) &bmp_data, NULL, 0);
	if (bmp_handle == NULL)
	{
		debug_message ("slider::size_changed: CreateDIBSection failed.");
		return (false);
	}
	return (true);
}


void
gradient::blend (void)
{
	int		i;

	DWORD	*cur_pos;
	int	prev_pos, next_pos;

	DWORD	*prgb;	// pointer to first pixel from the blend
	int		nSkip;	// number of pixels to skip after current row and before next one

	DWORD	*p;		// loop pointers

	int		width = frame.right - frame.left;
	int		height = frame.bottom - frame.top;
	int		blend_width = blend_rect.right - blend_rect.left + 1;
	int		blend_height = blend_rect.bottom - blend_rect.top + 1;

	cur_pos = row_buffer;
	prev_pos = 0;
	for (i=1; i<num_anchors; i++)
	{
		// calculate position of the next anchor
		next_pos = anchor_in_pixels (i);

		// draw blend and advance
		blend::rgb (
			cur_pos,
			next_pos - prev_pos + 1,
			anchors [i - 1].color,
			anchors [i].color);
		cur_pos += (next_pos - prev_pos);
		prev_pos = next_pos;
	}
	ASSERT (cur_pos - row_buffer == row_buff_size - 1);

	// reverse if necessary
	//	when slider is horizontal, x = 0 is at the left
	//	when slider is vertical, y = 0 is at the bottom
	if ((layout_mode & layout_vertical) && !(visual_mode & modes::reverse) ||
		(layout_mode & layout_horizontal) && (visual_mode & modes::reverse))
		mem::reverse (row_buffer, row_buff_size);

	// prepare
	prgb = bmp_data +
		(height - blend_rect.bottom - 1) * width + // top rows
		blend_rect.left; // pixels on first row
	nSkip = blend_rect.left +
		width - blend_rect.right - 1;
	p = prgb;

	if (layout_mode & layout_horizontal)
	{
		i = blend_height;
		while (i--) mem::copy (&p, row_buffer, blend_width), p += nSkip;
	}
	else // if (layout_mode & layout_vertical)
	{
		DWORD	*source = row_buffer;

		i = blend_height;
		while (i--) mem::set (&p, *source++, blend_width), p += nSkip;
	}
}



} // xgui namespace
