// xgui 0.0.4 / 2002-08-07
//	gradient.h
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_gradient_h
#define	_gradient_h

#include "base.h"
#include "xgui.h"



namespace xgui {


// number of anchors to allocate or reallocate
const int ANCHORS_GROW_COUNT = 8;


struct anchor
{
	int id;
	int position;
	COLORREF color;
};


class gradient : public base
{
public:
	gradient (void);
	~gradient ();

	// register and unregister class methods
	static bool	register_class (
		IN HINSTANCE library_instance);

	static bool	unregister_class (
		IN HINSTANCE library_instance);

	// initialization
	bool setup (
		IN HWND hwnd,
		IN LPCREATESTRUCT pcs);

	// user interaction
	virtual void mouse_move (
		IN short x,
		IN short y,
		IN int modifiers);

	virtual void mouse_down (
		IN enum mouse_buttons button,
		IN short x,
		IN short y,
		IN int modifiers);

	virtual void mouse_wheel (
		IN short /* delta */) { };

	virtual void key_down (
		IN int /* key_code */,
		IN int /* modifiers */) { };

	// painting methods
	void paint (
		IN LPPAINTSTRUCT /* pnt */);

	// called, when window size has changed
	virtual bool size_changed (
		IN int hsize,
		IN int vsize);

	enum layouts
	{
		layout_horizontal = 0x8000,	// horizontal gradient
		layout_tr_top = 0x2000,		// triangles
		layout_tr_bottom = 0x1000,

		layout_vertical = 0x4000,	// vertical gradient
		layout_tr_left = 0x2000,	// triangles
		layout_tr_right = 0x1000,
	};

private:
	// get/set layout
	inline int layout (void) const { return (layout_mode); };
	void layout (
		IN int value);

	// get/set visual mode
	inline int visual (void) const { return (visual_mode & modes::mask); };
	void visual (
		IN int value);

	// repaint window control
	inline void repaint (void) const { InvalidateRect (hwnd, NULL, FALSE); };

	bool add_anchor (
		IN int id,
		IN int position,
		IN COLORREF color);

	bool remove_anchor (
		IN int id);

	// returns anchor position in pixels (x or y depends on layout mode)
	int anchor_in_pixels (
		IN int index) const;

private:
	anchor	*anchors;					// an array with anchors
	int	num_anchors, allocated_anchors;	// number of active and allocated anchors
	int	size;							// total "width" of the gradient
	int	selected_anchor;				// index (0-based) or -1

	int		visual_mode;				// could be modes::reverse or 0
	int		layout_mode;				// combination of layouts enum
	RECT	panel_rect;
	RECT	blend_rect;
	int		triangle_size;

	DWORD	*row_buffer;			// 1px-high 32-bit bitmap, having same width as blend
	int		row_buff_size;			// size of the row buffer in doublewords

	// cache DIB bitmap information
	BITMAPINFO	bmp_info;
	HBITMAP		bmp_handle;
	DWORD		*bmp_data;

	// painting methods
	void blend (void);

public:
	virtual const char *window_class_name (void) const { return (class_name); };

	// registered window class information
	static const char	*class_name;
	static WNDCLASS		window_class;
	static ATOM			class_atom;
};

} // xgui namespace



#endif	// _gradient_h
