// xgui 0.0.4 / 2002-08-07
//	main.cpp
//
//	http://606u.dir.bg/
//	606u@dir.bg

#include "_p.h"

#include "xgui.h"

#include "well.h"
#include "slider.h"
#include "picker.h"
#include "gradient.h"
#include "controller.h"



// initialized flag
bool	xgui_initialized = false;

// total number of processed attached
int	attached_processes = 0;

// library-wide module handle (for LoadResource)
HINSTANCE	library_instance;



BOOL APIENTRY
DllMain (
	IN HANDLE module_handle,
	IN DWORD reason_for_call,
	IN LPVOID /* reserved */)
{
	switch (reason_for_call)
	{
	case	DLL_PROCESS_ATTACH:
		xgui::debug_message ("DllMain: process attached.");
		library_instance = (HINSTANCE) module_handle;
		if (!xgui_initialized)
		{
			// register window class(es)
			if (!xgui::well::register_class ((HINSTANCE) module_handle) ||
				!xgui::slider::register_class ((HINSTANCE) module_handle) ||
				!xgui::picker::register_class ((HINSTANCE) module_handle) ||
				!xgui::gradient::register_class ((HINSTANCE) module_handle) ||
				!xgui::controller::register_class ((HINSTANCE) module_handle))
			{
				xgui::well::unregister_class ((HINSTANCE) module_handle);
				xgui::slider::unregister_class ((HINSTANCE) module_handle);
				xgui::picker::unregister_class ((HINSTANCE) module_handle);
				xgui::gradient::unregister_class ((HINSTANCE) module_handle);
				xgui::controller::unregister_class ((HINSTANCE) module_handle);
				xgui::debug_message ("DllMain: register_class failed; aborting.");
				return (FALSE);
			}
			xgui::debug_message ("DllMain: classes registered.");
			xgui_initialized = true;
		}
		attached_processes++;
		break;

	case	DLL_PROCESS_DETACH:
		xgui::debug_message ("DllMain: process detached.");
		attached_processes--;
		if (attached_processes == 0)
		{
			// unregister window class(es)
			xgui::well::unregister_class ((HINSTANCE) module_handle);
			xgui::slider::unregister_class ((HINSTANCE) module_handle);
			xgui::picker::unregister_class ((HINSTANCE) module_handle);
			xgui::gradient::unregister_class ((HINSTANCE) module_handle);
			xgui::controller::unregister_class ((HINSTANCE) module_handle);
			xgui::debug_message ("DllMain: classes unregistered.");
		}
		library_instance = NULL;
		break;
	}
    return (TRUE);
}


BOOL
xgui_initialize (void)
{
	xgui::debug_message ("xgui_initialize: done.");
	return (TRUE);
}
