// xgui 0.0.4 / 2002-08-07
//	web_palette.cpp
//
//	http://606u.dir.bg/
//	606u@dir.bg

#include "_p.h"

#include "palette.h"



namespace xgui {


const COLORREF named_web_colors [] = 
{
	0x00F0F8FF,	// aliceblue
	0x00FAEBD7,	// antiquewhite
	0x0000FFFF,	// aqua
	0x007FFFD4,	// aquamarine
	0x00F0FFFF,	// azure
	0x00F5F5DC,	// beige
	0x00FFE4C4,	// bisque
	0x00000000,	// black
	0x00FFEBCD,	// blanchedalmond
	0x000000FF,	// blue
	0x008A2BE2,	// blueviolet
	0x00A52A2A,	// brown
	0x00DEB887,	// burlywood
	0x005F9EA0,	// cadetblue
	0x007FFF00,	// chartreuse
	0x00D2691E,	// chocolate
	0x00FF7F50,	// coral
	0x006495ED,	// cornflowerblue
	0x00FFF8DC,	// cornsilk
	0x00DC143C,	// crimson
	0x0000FFFF,	// cyan
	0x0000008B,	// darkblue
	0x00008B8B,	// darkcyan
	0x00B8860B,	// darkgoldenrod
	0x00A9A9A9,	// darkgray
	0x00006400,	// darkgreen
	0x00BDB76B,	// darkkhaki
	0x008B008B,	// darkmagenta
	0x00556B2F,	// darkolivegreen
	0x00FF8C00,	// darkorange
	0x009932CC,	// darkorchid
	0x008B0000,	// darkred
	0x00E9967A,	// darksalmon
	0x008FBC8B,	// darkseagreen
	0x00483D8B,	// darkslateblue
	0x002F4F4F,	// darkslategray
	0x0000CED1,	// darkturquoise
	0x009400D3,	// darkviolet
	0x00FF1493,	// deeppink
	0x0000BFFF,	// deepskyblue
	0x00696969,	// dimgray
	0x001E90FF,	// dodgerblue
	0x00B22222,	// firebrick
	0x00FFFAF0,	// floralwhite
	0x00228B22,	// forestgreen
	0x00FF00FF,	// fuchsia
	0x00DCDCDC,	// gainsboro
	0x00F8F8FF,	// ghostwhite
	0x00FFD700,	// gold
	0x00DAA520,	// goldenrod
	0x00808080,	// gray
	0x00008000,	// green
	0x00ADFF2F,	// greenyellow
	0x00F0FFF0,	// honeydew
	0x00FF69B4,	// hotpink
	0x00CD5C5C,	// indianred
	0x004B0082,	// indigo
	0x00FFFFF0,	// ivory
	0x00F0E68C,	// khaki
	0x00E6E6FA,	// lavender
	0x00FFF0F5,	// lavenderblush
	0x007CFC00,	// lawngreen
	0x00FFFACD,	// lemonchiffon
	0x00ADD8E6,	// lightblue
	0x00F08080,	// lightcoral
	0x00E0FFFF,	// lightcyan
	0x00FAFAD2,	// lightgoldenrodyellow
	0x0090EE90,	// lightgreen
	0x00D3D3D3,	// lightgrey
	0x00FFB6C1,	// lightpink
	0x00FFA07A,	// lightsalmon
	0x0020B2AA,	// lightseagreen
	0x0087CEFA,	// lightskyblue
	0x00778899,	// lightslategray
	0x00B0C4DE,	// lightsteelblue
	0x00FFFFE0,	// lightyellow
	0x0000FF00,	// lime
	0x0032CD32,	// limegreen
	0x00FAF0E6,	// linen
	0x00FF00FF,	// magenta
	0x00800000,	// maroon
	0x0066CDAA,	// mediumaquamarine
	0x000000CD,	// mediumblue
	0x00BA55D3,	// mediumorchid
	0x009370DB,	// mediumpurple
	0x003CB371,	// mediumseagreen
	0x007B68EE,	// mediumslateblue
	0x0000FA9A,	// mediumspringgreen
	0x0048D1CC,	// mediumturquoise
	0x00C71585,	// mediumvioletred
	0x00191970,	// midnightblue
	0x00F5FFFA,	// mintcream
	0x00FFE4E1,	// mistyrose
	0x00FFE4B5,	// moccasin
	0x00FFDEAD,	// navajowhite
	0x00000080,	// navy
	0x00FDF5E6,	// oldlace
	0x00808000,	// olive
	0x006B8E23,	// olivedrab
	0x00FFA500,	// orange
	0x00FF4500,	// orangered
	0x00DA70D6,	// orchid
	0x00EEE8AA,	// palegoldenrod
	0x0098FB98,	// palegreen
	0x00AFEEEE,	// paleturquoise
	0x00DB7093,	// palevioletred
	0x00FFEFD5,	// papayawhip
	0x00FFDAB9,	// peachpuff
	0x00CD853F,	// peru
	0x00FFC0CB,	// pink
	0x00DDA0DD,	// plum
	0x00B0E0E6,	// powderblue
	0x00800080,	// purple
	0x00FF0000,	// red
	0x00BC8F8F,	// rosybrown
	0x004169E1,	// royalblue
	0x008B4513,	// saddlebrown
	0x00FA8072,	// salmon
	0x00F4A460,	// sandybrown
	0x002E8B57,	// seagreen
	0x00FFF5EE,	// seashell
	0x00A0522D,	// sienna
	0x00C0C0C0,	// silver
	0x0087CEEB,	// skyblue
	0x006A5ACD,	// slateblue
	0x00708090,	// slategray
	0x00FFFAFA,	// snow
	0x0000FF7F,	// springgreen
	0x004682B4,	// steelblue
	0x00D2B48C,	// tan
	0x00008080,	// teal
	0x00D8BFD8,	// thistle
	0x00FF6347,	// tomato
	0x0040E0D0,	// turquoise
	0x00EE82EE,	// violet
	0x00F5DEB3,	// wheat
	0x00FFFFFF,	// white
	0x00F5F5F5,	// whitesmoke
	0x00FFFF00,	// yellow
	0x009ACD32,	// yellowgreen
};


palette::palette (
	IN WORD resource_id,
	OPTIONAL IN HINSTANCE library_instance)	// = NULL
{
	bool	success = false;

	if (library_instance == NULL)
		library_instance = ::library_instance;

	// get resource info
	HRSRC	resource_info = FindResource (
		library_instance,
		MAKEINTRESOURCE (resource_id),
		RT_RCDATA);
	if (resource_info)
	{
		// load resource
		HGLOBAL	resource_handle = LoadResource (
			library_instance,
			resource_info);
		if (resource_info)
		{
			// request resource data
			DWORD	*palette = (DWORD *) LockResource (resource_handle);
			DWORD	colors = SizeofResource (
				library_instance,
				resource_info);
			// build lut
			build (
				palette,
				(short) (colors / sizeof (DWORD)));
			success = true;
			// that's all
			FreeResource (resource_handle);
		}
	}

	if (resource_id == (WORD) -1)
	{
		// build lut for web named colors
		build (
			named_web_colors,
			sizeof (named_web_colors) / sizeof (named_web_colors [0]));
		success = true;
	}

	if (!success)
	{
		// initialize default on error
		for (unsigned char b=0; b<16; b++)
			for (unsigned char g=0; g<16; g++)
				for (unsigned char r=0; r<16; r++)
				{
					index2rgb [b << 8 | g << 4 | r] = RGB (r << 4, g << 4, b << 4);
					index2bgr [b << 8 | g << 4 | r] = RGB (b << 4, g << 4, r << 4);
				}
	}
}


void
palette::build (
	IN const DWORD *palette,
	IN unsigned short colors)
{
	unsigned char	r, g, b;	// loop counters
	unsigned short	i;

	// since this will only be done once, use brute-force approach
	// there is no point to optimize that one
	for (b=0; b<16; b++)
		for (g=0; g<16; g++)
			for (r=0; r<16; r++)
			{
				unsigned short	best_match_index = 0;
				long	best_match_distance = 0x01000000;

				// find best match
				for (i=0; i<colors; i++)
				{
					unsigned char	rr = GetRValue (palette [i]);
					unsigned char	gg = GetGValue (palette [i]);
					unsigned char	bb = GetBValue (palette [i]);

					// since we're cutting lower 4 bits "center" color
					// in the middle
					unsigned char	rrr = (unsigned char) ((r << 4) | 0x07);
					unsigned char	ggg = (unsigned char) ((g << 4) | 0x07);
					unsigned char	bbb = (unsigned char) ((b << 4) | 0x07);

					long cur_distance = /* sqrt */ (
						(rrr - rr) * (rrr - rr) +
						(ggg - gg) * (ggg - gg) +
						(bbb - bb) * (bbb - bb));
					if (cur_distance < best_match_distance)
					{
						best_match_index = i;
						best_match_distance = cur_distance;
					}
				}

				// keep that one
				index2rgb [b << 8 | g << 4 | r] = palette [best_match_index];
				index2bgr [b << 8 | g << 4 | r] =
					convert::bgr (palette [best_match_index]);
			}
}


} // xgui namespace
