// xgui 0.0.4 / 2002-08-07
//	palette.h
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_palette_h
#define	_palette_h

#include "xgui_statics.h"


// from main.cpp - for LoadResource
extern HINSTANCE library_instance;

namespace xgui {


class palette
{
private:
	// for best performance 32-bit (actually 24-bit) RGB color - 00BBGGRR
	// is converted to 16-bit (actually 12-bit) RGB color - 0BGR
	// by removing lower 4 bits for each color component -> 12-bits totally
	// resulting value is used as an index in the following array
	COLORREF	index2rgb [16 * 16 * 16];
	COLORREF	index2bgr [16 * 16 * 16];

	// build a lut table from a palette
	void build (
		IN const DWORD *palette,
		IN unsigned short colors);

public:
	// create from a resource
	palette (
		IN WORD resource_id,
		OPTIONAL IN HINSTANCE library_instance = NULL);

	// return matching color
	inline COLORREF match_rgb (
		IN COLORREF rgb);

	inline COLORREF match_bgr (
		IN COLORREF bgr);

	// convert a strip
	inline void match_rgb_strip (
		IN OUT DWORD *buffer,
		IN int samples);

	inline void match_bgr_strip (
		IN OUT DWORD *buffer,
		IN int samples);
};


inline COLORREF
palette::match_rgb (
	IN COLORREF rgb)
{
	short ndx = convert::RGB24_2_RGB12 (rgb);
	COLORREF c = index2rgb [ndx];
	return (c);
}


inline COLORREF
palette::match_bgr (
	IN COLORREF bgr)
{
	short ndx = convert::BGR24_2_RGB12 (bgr);
	COLORREF c = index2bgr [ndx];
	return (c);
}


inline void
palette::match_rgb_strip (
	IN OUT DWORD *buffer,
	IN int samples)
{
	while (samples--)
	{
		COLORREF c = match_rgb (*buffer);
		*buffer = c;
		buffer++;
	}
}


inline void
palette::match_bgr_strip (
	IN OUT DWORD *buffer,
	IN int samples)
{
	while (samples--)
	{
		COLORREF c = match_bgr (*buffer);
		*buffer = c;
		buffer++;
	}
}


} // xgui namespace


#endif	// _palette_h
