// xgui 0.0.4 / 2002-08-07
//	picker.h
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_picker_h
#define	_picker_h

#include "base.h"
#include "xgui.h"



namespace xgui {


// set following constant to 1 in order to have a constant marker
//	instead of XOR-ed one, but blend will be redrawn on each WM_PAINT;
//	XOR-ed marker doesn't look well on grays around 50%
const int CONTRAST_MARKER = 1;

// radius of picker's marker; 5 will match on cursor size (shape)
const int MARKER_SIZE = 5;


//
// picker user control sub-style (16-bits):
//
//              +--------+- spacing size - 1 (or 0 here is actual size 1)
//              |        |
// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
// |16|15|14|13|12|11|10| 9| 8| 7| 6| 5| 4| 3| 2| 1|
// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//
class	picker : public base
{
public:
	picker (void);
	virtual	~picker ();

	// register and unregister class methods
	static bool register_class (
		IN HINSTANCE library_instance);

	static bool unregister_class (
		IN HINSTANCE library_instance);

	// initialization
	bool setup (
		IN HWND hwnd,
		IN LPCREATESTRUCT pcs);

	// user interaction methods
	void mouse_move (
		IN short x,
		IN short y,
		IN int modifiers);

	void mouse_up (
		IN enum mouse_buttons button,
		IN short x,
		IN short y,
		IN int modifiers);

	void mouse_wheel (
		IN short delta);

	void key_down (
		IN int key_code,
		IN int modifiers);

	// painting methods
	void paint (
		IN LPPAINTSTRUCT pnt);

	// called, when window size has changed
	bool size_changed (
		IN int hsize,
		IN int vsize);

	LRESULT control_message (
		IN enum control_codes message,
		IN WPARAM wparam,
		IN LPARAM lparam);

	// get/set visual mode
	inline int visual (void) const { return (visual_mode); };
	void visual (
		IN int value);

	// get/set additional component's value
	inline int component (void) const { return (additional_component); };
	void component (
		IN int value);

	// get/set current color
	COLORREF color (void) const;
	void color (
		IN COLORREF value);

	// get/set current x-axis position
	inline int xpos (void) const { return (x_pos); };
	void xpos (
		IN int value);

	// get/set current y-axis position
	inline int ypos (void) const { return (y_pos); };
	void ypos (
		IN int value);

	// repaint window control
	inline void repaint (void) const { InvalidateRect (hwnd, NULL, FALSE); };

private:
	int		visual_mode;
	int		additional_component;
	int		x_pos;
	int		y_pos;
	int		max_x;
	int		max_y;
	int		old_x, old_y;
	RECT	panel_rect, blend_rect;
	bool	should_repaint;

	// cache DIB bitmap information
	BITMAPINFO	bmp_info;
	HBITMAP		bmp_handle;
	DWORD		*bmp_data;

	void calculate_colors (
		OUT COLORREF &lefttop,
		OUT COLORREF &righttop,
		OUT COLORREF &leftbottom,
		OUT COLORREF &rightbottom);

	void blend (void);

	// draws blend in rgb mode - includes red, green and blue modes
	void blend_rgb (void);

	// draws blend in hsv mode - hue, sat and value modes separately
	void blend_hsv_hue (void);
	void blend_hsv_sat (void);
	void blend_hsv_value (void);

	// draws blend in hls mode - hue, light and sat modes separately
	void blend_hls_hue (void);
	void blend_hls_light (void);
	void blend_hls_sat (void);

public:
	virtual const char *window_class_name (void) { return (class_name); };

	// registered window class information
	static const char	*class_name;
	static WNDCLASS		window_class;
	static ATOM			class_atom;

protected:
	static HCURSOR	picker_cursor;
};

} // xgui namespace



#endif	// _picker_h
