// xgui 0.0.4 / 2002-08-07
//	picker_blends.cpp
//
//	http://606u.dir.bg/
//	606u@dir.bg

#include "_p.h"

#include "xgui.h"
#include "picker.h"

#include "palette.h"



namespace xgui {


void
picker::blend (void)
{
	switch (visual_mode)
	{
	case	modes::rgb_red:
	case	modes::rgb_green:
	case	modes::rgb_blue:	blend_rgb (); break;
	case	modes::hsv_hue:		blend_hsv_hue (); break;
	case	modes::hsv_sat:		blend_hsv_sat (); break;
	case	modes::hsv_value:	blend_hsv_value (); break;
	case	modes::hls_hue:		blend_hls_hue (); break;
	case	modes::hls_light:	blend_hls_light (); break;
	case	modes::hls_sat:		blend_hls_sat (); break;
	}
}


void
picker::calculate_colors (
	OUT COLORREF &lefttop,
	OUT COLORREF &righttop,
	OUT COLORREF &leftbottom,
	OUT COLORREF &rightbottom)
{
	BYTE	c = (BYTE) ((int) additional_component * 255 / max::rgb);

	switch (visual_mode)
	{
	case	modes::rgb_red:
		lefttop = RGB (c, 255, 0);
		righttop = RGB (c, 255, 255);
		leftbottom = RGB (c, 0, 0);
		rightbottom = RGB (c, 0, 255);
		break;

	case	modes::rgb_green:
		lefttop = RGB (255, c, 0);
		righttop = RGB (255, c, 255);
		leftbottom = RGB (0, c, 0);
		rightbottom = RGB (0, c, 255);
		break;

	case	modes::rgb_blue:
		lefttop = RGB (0, 255, c);
		righttop = RGB (255, 255, c);
		leftbottom = RGB (0, 0, c);
		rightbottom = RGB (255, 0, c);
		break;

	default:
		debug_message ("picker: unknown visual_mode - %d", visual_mode);
	}
}


void
picker::blend_rgb (void)
{
	int		i;		// loop counters
	int		j;

	int		nSkip;	// number of pixels to skip after current row and before next one

	DWORD	*p;		// pointer to first pixel from the blend & a loop pointer

	int		width = frame.right - frame.left;
	int		height = frame.bottom - frame.top;
	int		blend_width = blend_rect.right - blend_rect.left + 1;
	int		blend_height = blend_rect.bottom - blend_rect.top + 1;
	
	// left side components, extended with int_extend bits
	int		left_red, left_green, left_blue;
	// left side component advance, extended with int_extend bits
	int		left_red_adv, left_green_adv, left_blue_adv;
	int		right_red, right_green, right_blue;
	int		right_red_adv, right_green_adv, right_blue_adv;

	// current components, extended with int_extend bits
	int		red, green, blue;
	// advance, extended with int_extend bits
	int		red_adv, green_adv, blue_adv;

	COLORREF	lefttop, righttop, leftbottom, rightbottom;

	p = bmp_data +
		(height - blend_rect.bottom - 1) * width + // top rows
		blend_rect.left; // pixels on first row
	nSkip = blend_rect.left +
		width - blend_rect.right - 1;

	calculate_colors (lefttop, righttop, leftbottom, rightbottom);

	left_red = convert::scaled_red (leftbottom);
	left_green = convert::scaled_green (leftbottom);
	left_blue = convert::scaled_blue (leftbottom);
	left_red_adv = (convert::scaled_red (lefttop) - left_red) / (blend_height - 1);
	left_green_adv = (convert::scaled_green (lefttop) - left_green) / (blend_height - 1);
	left_blue_adv = (convert::scaled_blue (lefttop) - left_blue) / (blend_height - 1);

	right_red = convert::scaled_red (rightbottom);
	right_green = convert::scaled_green (rightbottom);
	right_blue = convert::scaled_blue (rightbottom);
	right_red_adv = (convert::scaled_red (righttop) - right_red) / (blend_height - 1);
	right_green_adv = (convert::scaled_green (righttop) - right_green) / (blend_height - 1);
	right_blue_adv = (convert::scaled_blue (righttop) - right_blue) / (blend_height - 1);

	// outer loop - rows
	i = blend_height;
	while (i--)
	{
		red = left_red;
		green = left_green;
		blue = left_blue;
		red_adv = (right_red - red) / (blend_width - 1);
		green_adv = (right_green - green) / (blend_width - 1);
		blue_adv = (right_blue - blue) / (blend_width - 1);

		// inner loop - pixels @ each row
		j = blend_width;
		if (palette)
		{
			// match to palette colors
			while (j--)
			{
				// in DIB bitmap values are 0BGR
				*p++ = palette->match_bgr (RGB (
					blue >> int_extend,
					green >> int_extend,
					red >> int_extend));

				// advance to the next pixel
				red += red_adv; green += green_adv; blue += blue_adv;
			}
		}
		else
		{
			// no palette
			while (j--)
			{
				// in DIB bitmap values are 0BGR
				*p++ = RGB (
					blue >> int_extend,
					green >> int_extend,
					red >> int_extend);

				// advance to the next pixel
				red += red_adv; green += green_adv; blue += blue_adv;
			}
		}

		// advance to the next row
		left_red += left_red_adv;
		left_green += left_green_adv;
		left_blue += left_blue_adv;
		right_red += right_red_adv;
		right_green += right_green_adv;
		right_blue += right_blue_adv;
		p += nSkip;
	}
}


void
picker::blend_hsv_hue (void)
{
	int		i;		// loop counters

	DWORD	*p;		// pointer to first pixel from the blend & a loop pointer
	int		nSkip;	// number of pixels to skip after current row and before next one

	int		width = frame.right - frame.left;
	int		height = frame.bottom - frame.top;
	int		blend_width = blend_rect.right - blend_rect.left + 1;
	int		blend_height = blend_rect.bottom - blend_rect.top + 1;

	double	hue;
	double	val, val_adv;

	p = bmp_data +
		(height - blend_rect.bottom - 1) * width + // top rows
		blend_rect.left; // pixels on first row
	nSkip = blend_rect.left +
		width - blend_rect.right - 1;

	// constant
	hue = additional_component / (double) scale::hsv_hue;

	// outer loop - rows
	i = blend_height;

	// initial and change
	val = 0.0;
	val_adv = 1.0 / i;
	
	while (i--)
	{
		//
		// val changes vertically in [0, 1]; loop
		// sat changes horizontally in [0, 1]; function called
		//
		blend::hsv_sat (p, blend_width, hue, val);

		// match colors to palette if installed
		if (palette)
			palette->match_bgr_strip (p, blend_width);

		// advance to the next row
		val += val_adv;
		p += (blend_width + nSkip);
	}
}


void
picker::blend_hsv_sat (void)
{
	int		i;		// loop counters

	int		nSkip;	// number of pixels to skip after current row and before next one

	DWORD	*p;		// pointer to first pixel from the blend & a loop pointer

	int		width = frame.right - frame.left;
	int		height = frame.bottom - frame.top;
	int		blend_width = blend_rect.right - blend_rect.left + 1;
	int		blend_height = blend_rect.bottom - blend_rect.top + 1;

	double	sat;
	double	val, val_adv;

	p = bmp_data +
		(height - blend_rect.bottom - 1) * width + // top rows
		blend_rect.left; // pixels on first row
	nSkip = blend_rect.left +
		width - blend_rect.right - 1;

	// constant
	sat = additional_component / (double) scale::hsv_sat;

	// outer loop - rows
	i = blend_height;

	// initial and change
	val = 0.0;
	val_adv = 1.0 / i;

	while (i--)
	{
		//
		// val changes vertically in [0, 1]; loop
		// hue changes horizontally in [0, 360); function called
		//
		blend::hsv_hue (p, blend_width, sat, val);

		// match colors to palette if installed
		if (palette)
			palette->match_bgr_strip (p, blend_width);

		// advance to the next row
		val += val_adv;
		p += (blend_width + nSkip);
	}
}


void
picker::blend_hsv_value (void)
{
	int		i;		// loop counters

	int		nSkip;	// number of pixels to skip after current row and before next one

	DWORD	*p;		// pointer to first pixel from the blend & a loop pointer

	int		width = frame.right - frame.left;
	int		height = frame.bottom - frame.top;
	int		blend_width = blend_rect.right - blend_rect.left + 1;
	int		blend_height = blend_rect.bottom - blend_rect.top + 1;

	double	sat;
	double	sat_adv;
	double	val;

	p = bmp_data +
		(height - blend_rect.bottom - 1) * width + // top rows
		blend_rect.left; // pixels on first row
	nSkip = blend_rect.left +
		width - blend_rect.right - 1;

	// constant
	val = additional_component / (double) scale::hsv_value;

	// outer loop - rows
	i = blend_height;

	// initial and change
	sat = 0.0;
	sat_adv = 1.0 / i;

	while (i--)
	{
		//
		// sat changes vertically in [0, 1]; loop
		// hue changes horizontally in [0, 360); function called
		//
		blend::hsv_hue (p, blend_width, sat, val);

		// match colors to palette if installed
		if (palette)
			palette->match_bgr_strip (p, blend_width);

		// advance to the next row
		sat += sat_adv;
		p += (blend_width + nSkip);
	}
}


void
picker::blend_hls_hue (void)
{
	int		i;		// loop counters

	DWORD	*p;		// pointer to first pixel from the blend & a loop pointer
	int		nSkip;	// number of pixels to skip after current row and before next one

	int		width = frame.right - frame.left;
	int		height = frame.bottom - frame.top;
	int		blend_width = blend_rect.right - blend_rect.left + 1;
	int		blend_height = blend_rect.bottom - blend_rect.top + 1;

	double	hue;
	double	light, light_adv;

	p = bmp_data +
		(height - blend_rect.bottom - 1) * width + // top rows
		blend_rect.left; // pixels on first row
	nSkip = blend_rect.left +
		width - blend_rect.right - 1;

	// constant
	hue = additional_component / (double) scale::hls_hue;

	// outer loop - rows
	i = blend_height;

	// initial and change
	light = 0.0;
	light_adv = 1.0 / i;
	
	while (i--)
	{
		//
		// sat changes vertically in [0, 1]; loop
		// light changes horizontally in [0, 1]; function called
		//
		blend::hls_sat (p, blend_width, hue, light);

		// match colors to palette if installed
		if (palette)
			palette->match_bgr_strip (p, blend_width);

		// advance to the next row
		light += light_adv;
		p += (blend_width + nSkip);
	}
}


void
picker::blend_hls_light (void)
{
	int		i;		// loop counters

	int		nSkip;	// number of pixels to skip after current row and before next one

	DWORD	*p;		// pointer to first pixel from the blend & a loop pointer

	int		width = frame.right - frame.left;
	int		height = frame.bottom - frame.top;
	int		blend_width = blend_rect.right - blend_rect.left + 1;
	int		blend_height = blend_rect.bottom - blend_rect.top + 1;

	double	light;
	double	sat, sat_adv;

	p = bmp_data +
		(height - blend_rect.bottom - 1) * width + // top rows
		blend_rect.left; // pixels on first row
	nSkip = blend_rect.left +
		width - blend_rect.right - 1;

	// constant
	light = additional_component / (double) scale::hls_light;

	// outer loop - rows
	i = blend_height;

	// initial and change
	sat = 0.0;
	sat_adv = 1.0 / i;

	while (i--)
	{
		//
		// sat changes vertically in [0, 1]; loop
		// hue changes horizontally in [0, 360); function called
		//
		blend::hls_hue (p, blend_width, light, sat);

		// match colors to palette if installed
		if (palette)
			palette->match_bgr_strip (p, blend_width);

		// advance to the next row
		sat += sat_adv;
		p += (blend_width + nSkip);
	}
}


void
picker::blend_hls_sat (void)
{
	int		i;		// loop counters

	int		nSkip;	// number of pixels to skip after current row and before next one

	DWORD	*p;		// pointer to first pixel from the blend & a loop pointer

	int		width = frame.right - frame.left;
	int		height = frame.bottom - frame.top;
	int		blend_width = blend_rect.right - blend_rect.left + 1;
	int		blend_height = blend_rect.bottom - blend_rect.top + 1;

	double	sat;
	double	light, light_adv;

	p = bmp_data +
		(height - blend_rect.bottom - 1) * width + // top rows
		blend_rect.left; // pixels on first row
	nSkip = blend_rect.left +
		width - blend_rect.right - 1;

	// constant
	sat = additional_component / (double) scale::hls_sat;

	// outer loop - rows
	i = blend_height;

	// initial and change
	light = 0.0;
	light_adv = 1.0 / i;

	while (i--)
	{
		//
		// sat changes vertically in [0, 1]; loop
		// hue changes horizontally in [0, 360); function called
		//
		blend::hls_hue (p, blend_width, light, sat);

		// match colors to palette if installed
		if (palette)
			palette->match_bgr_strip (p, blend_width);

		// advance to the next row
		light += light_adv;
		p += (blend_width + nSkip);
	}
}

} // xgui namespace
