// xgui 0.0.4 / 2002-08-07
//	picker_wrapper.inl
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_picker_wrapper_h
#define	_picker_wrapper_h

#include "picker.h"


namespace xgui {

namespace wrapper {

class	picker
{
public:
	inline picker (void);
	inline picker (
		IN HWND window);

	// attaches class instance to a control
	inline void	attach (
		IN HWND window);

	// detaches control from the class instance
	inline void	detach (void);

	// returns whether class instance is currently attached to a control
	inline bool	attached (void) const;

	// returns window handle for control class is attached with
	inline HWND	window_handle (void) const;

	// attaches control to a master (controller)
	inline void	master_attach (
		IN HWND window);

public:
	// get/set picker's visual mode (xgui::modes::visual - "xgui_constants.h")
	inline int visual (void) const;
	inline void	visual (
		IN int value);

	// get/set component
	inline int component (void) const;
	inline void	component (
		IN int value);

	// get/set x-axis position
	inline int x_pos (void) const;
	inline void x_pos (
		IN int value);

	// get/set y-axis position
	inline int y_pos (void) const;
	inline void y_pos (
		IN int value);

	// get/set picker's color
	inline COLORREF	color (void) const;
	inline void	color (
		IN COLORREF value);

private:
	HWND	hwnd;
};


inline picker::picker (void)
{
	hwnd = NULL;
}


inline picker::picker (
	IN HWND window)
	: hwnd (window)
{
}


inline void
picker::attach (
	IN HWND window)
{
	hwnd = window;
}


inline void
picker::detach (void)
{
	hwnd = NULL;
}


inline bool
picker::attached (void) const
{
	return (hwnd != NULL);
}


inline HWND
picker::window_handle (void) const
{
	return (hwnd);
}


inline void
picker::master_attach (
	IN HWND window)
{
	SendMessage (hwnd, xgui::messages::master_attach, 0, (LPARAM) window);
}


inline int
picker::visual (void) const
{
	return ((int) SendMessage (hwnd, xgui::messages::visual_get, 0, 0));
}


inline void
picker::visual (
	IN int value)
{
	SendMessage (hwnd, xgui::messages::visual_set, 0, value);
}


inline int
picker::component (void) const
{
	return ((int) SendMessage (hwnd, xgui::messages::component_get, 0, 0));
}


inline void
picker::component (
	IN int value)
{
	SendMessage (hwnd, xgui::messages::component_set, 0, value);
}


inline int
picker::x_pos (void) const
{
	return ((int) SendMessage (hwnd, xgui::messages::xpos_get, 0, 0));
}


inline void
picker::x_pos (
	IN int value)
{
	SendMessage (hwnd, xgui::messages::xpos_set, 0, value);
}


inline int
picker::y_pos (void) const
{
	return ((int) SendMessage (hwnd, xgui::messages::ypos_get, 0, 0));
}


inline void
picker::y_pos (
	IN int value)
{
	SendMessage (hwnd, xgui::messages::ypos_set, 0, value);
}


inline COLORREF
picker::color (void) const
{
	return ((COLORREF) SendMessage (hwnd, xgui::messages::color_get, 0, 0));
}


inline void
picker::color (COLORREF value)
{
	SendMessage (hwnd, xgui::messages::color_set, 0, (LPARAM) value);
}


} // wrapper namespace

} // xgui namespace

#endif	// _picker_wrapper_h
