// xgui 0.0.4 / 2002-08-07
//	slider.h
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_slider_h
#define	_slider_h

#include "base.h"
#include "xgui.h"



namespace xgui {

//
// slider user control sub-style (16-bits):
//
//  +- horizontal slider (8)
//	|  +- verical slider (4)
//  |  |  +- left / top triangle (2)
//  |  |  |  +- right / bottom triangle (1)
//  |  |  |  |  +--------+- triangle(s) size - 4 (or 0 here is actual size of 4)
//  |  |  |  |  |        |	+--------------------+- visual mode (modes enum)
//  |  |  |	 |	|		 |	|					 |
// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
// |16|15|14|13|12|11|10| 9| 8| 7| 6| 5| 4| 3| 2| 1|
// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//  |                    |
//  +--------------------+- layout mode
//
class	slider : public base
{
public:
	slider (void);
	virtual	~slider ();

	// register and unregister window class
	static bool register_class (
		IN HINSTANCE library_instance);

	static bool unregister_class (
		IN HINSTANCE library_instance);

	// set-up new control instance
	virtual bool setup (
		IN HWND hwnd,
		IN LPCREATESTRUCT pcs);

	// user interaction
	virtual void mouse_move (
		IN short x,
		IN short y,
		IN int modifiers);

	virtual void mouse_up (
		IN enum mouse_buttons button,
		IN short x,
		IN short y,
		IN int modifiers);

	virtual void mouse_wheel (
		IN short delta);

	virtual void key_down (
		IN int key_code,
		IN int modifiers);

	// painting methods
	virtual void paint (
		IN LPPAINTSTRUCT pnt);

	// called, when window size has changed
	virtual bool size_changed (
		IN int hsize,
		IN int vsize);

	virtual LRESULT control_message (
		IN enum control_codes message,
		IN WPARAM wparam,
		IN LPARAM lparam);

	enum layouts
	{
		layout_horizontal = 0x8000,	// horizontal slider
		layout_tr_top = 0x2000,		// triangles
		layout_tr_bottom = 0x1000,

		layout_vertical = 0x4000,	// vertical slider
		layout_tr_left = 0x2000,	// triangles
		layout_tr_right = 0x1000,
	};

private:
	// get/set layout
	inline int layout (void) const { return (layout_mode); };
	void layout (
		IN int value);

	// get/set visual mode
	inline int visual (void) const { return (visual_mode & modes::mask); };
	void visual (
		IN int value);

	// get/set value at the begining of the slider
	inline int start (void) const { return (start_val); };
	void start (
		IN int value);

	// get/set value at the end of the slider
	inline int end (void) const { return (end_val); };
	void end (
		IN int value);

	// get/set position of the slider
	inline int position (void) const { return (visual_mode & modes::reverse ? end_val - cur_pos : cur_pos); };
	void position (
		IN int value);

	// get/set one-of slider additional components
	inline int component (
		IN int index) const { return (additional_components [index]); };
	void component (
		IN int index,
		IN int value);

	// repaint window control
	inline void repaint (void) const { InvalidateRect (hwnd, NULL, FALSE); };

private:
	int		visual_mode;	// visual mode (colorspace)
	int		layout_mode;

	int		start_val;
	int		end_val;
	int		cur_pos;
	int		prev_pos;
	int		stepsize;
	int		pagesize;

	RECT	panel_rect;
	RECT	blend_rect;
	int		triangle_size;

//
// additional components depends on current visual mode (indexes given below):
// - rgb red - 0 is green in [0, 255], 1 is blue in [0, 255]
// - rgb green - 0 is red in [0, 255], 1 is blue in [0, 255]
// - rgb blue - 0 is red in [0, 255], 1 is green in [0, 255]
// - hsv hue - 0 is sat in [0, 1000 (1000 is 100.0% or 1.0)], 1 is value in [0, 1000]
// - hsv sat - 0 is hue in [0, 3599 (3599 is 359.9 degs)], 1 is value in [0, 1000]
// - hsv value - 0 is hue in [0, 3599], 1 is sat in [0, 1000]
//
	int		additional_components [4];

	DWORD	*row_buffer;			// 1px-high 32-bit bitmap, having same width as blend
	int		row_buff_size;			// size of the row buffer in doublewords

	// cache DIB bitmap information
	BITMAPINFO	bmp_info;
	HBITMAP		bmp_handle;
	DWORD		*bmp_data;

	// painting methods
	void blend (void);
	void blend_rgb (void);
	void blend_hsv_hue (void);
	void blend_hsv_sat (void);
	void blend_hsv_value (void);
	void blend_hls_hue (void);
	void blend_hls_light (void);
	void blend_hls_sat (void);

public:
	virtual const char *window_class_name (void) { return (class_name); };

	// registered window class information
	static bool			class_registered;
	static const char	*class_name;
	static WNDCLASS		window_class;
	static ATOM			class_atom;
};

} // xgui namespace



#endif	// _slider_h
