// xgui 0.0.4 / 2002-08-07
//	slider_blends.cpp
//
//	http://606u.dir.bg/
//	606u@dir.bg

#include "_p.h"

#include "xgui.h"
#include "slider.h"

#include "palette.h"



namespace xgui {


void
slider::blend (void)
{
	int	i;

	DWORD	*prgb;	// pointer to first pixel from the blend
	int		nSkip;	// number of pixels to skip after current row and before next one

	DWORD	*p;		// loop pointers

	int		width = frame.right - frame.left;
	int		height = frame.bottom - frame.top;
	int		blend_width = blend_rect.right - blend_rect.left + 1;
	int		blend_height = blend_rect.bottom - blend_rect.top + 1;

	//
	//	horizontal blend schema:
	//
	//	+--+--+--+--+--+--+
	//	|**|  |**|  |**|  | - selection frame
	//	+--+--+--+--+--+--+
	//	|  |  |  |  |  |  | - blank
	//	+--+--+--+--+--+--+
	//	................... - triangle (triangle-size blend_height)
	//	+--+--+--+--+--+--+
	//	|  |  |  |  |  |  | - blank
	//	+--+--+--+--+--+--+
	//	|**|  |xx|xx|xx|xx| - relief frame
	//	+--+--+--+--+--+--+
	//	|  |  |xx|XX|XX|XX| - black frame
	//	+--+--+--+--+--+--+
	//	|**|  |xx|XX| X+--+-- blend's 1st row (prgb pointer)
	//	+--+--+--+--+--+--+
	//

	// fill row buffer
	switch (visual_mode & modes::mask)
	{
	case	modes::rgb_red:
	case	modes::rgb_green:
	case	modes::rgb_blue:	blend_rgb (); break;
	case	modes::hsv_hue:		blend_hsv_hue (); break;
	case	modes::hsv_sat:		blend_hsv_sat (); break;
	case	modes::hsv_value:	blend_hsv_value (); break;
	case	modes::hls_hue:		blend_hls_hue (); break;
	case	modes::hls_light:	blend_hls_light (); break;
	case	modes::hls_sat:		blend_hls_sat (); break;
	default:
		// mode not supported?
		ASSERT (FALSE);
		return;
	}

	// reverse if necessary
	//	when slider is horizontal, x = 0 is at the left
	//	when slider is vertical, y = 0 is at the bottom
	if ((layout_mode & layout_vertical) && !(visual_mode & modes::reverse) ||
		(layout_mode & layout_horizontal) && (visual_mode & modes::reverse))
		mem::reverse (row_buffer, row_buff_size);

	// match colors to palette if installed
	if (palette)
		palette->match_bgr_strip (row_buffer, row_buff_size);

	// prepare
	prgb = bmp_data +
		(height - blend_rect.bottom - 1) * width + // top rows
		blend_rect.left; // pixels on first row
	nSkip = blend_rect.left +
		width - blend_rect.right - 1;
	p = prgb;

	if (layout_mode & layout_horizontal)
	{
		i = blend_height;
		while (i--) mem::copy (&p, row_buffer, blend_width), p += nSkip;
	}
	else // if (layout_mode & layout_vertical)
	{
		DWORD	*source = row_buffer;

		i = blend_height;
		while (i--) mem::set (&p, *source++, blend_width), p += nSkip;
	}
}


void
slider::blend_rgb (void)
{
	COLORREF	start_color, end_color;
	BYTE	c1, c2;

	c1 = (BYTE) ((int) additional_components [0] * 255 / max::rgb);
	c2 = (BYTE) ((int) additional_components [1] * 255 / max::rgb);

	// setup start and end color depending of current mode
	switch (visual_mode & modes::mask)
	{
	case	modes::rgb_red:
		start_color = RGB (0, c1, c2);
		end_color = RGB (255, c1, c2);
		break;

	case	modes::rgb_green:
		start_color = RGB (c1, 0, c2);
		end_color = RGB (c1, 255, c2);
		break;

	case	modes::rgb_blue:
		start_color = RGB (c1, c2, 0);
		end_color = RGB (c1, c2, 255);
		break;

	default:
		ASSERT (FALSE);
		return;
	}

	blend::rgb (row_buffer, row_buff_size, start_color, end_color);
}


void
slider::blend_hsv_hue (void)
{
	blend::hsv_hue (row_buffer, row_buff_size,
		additional_components [0] / (double) scale::hsv_sat,
		additional_components [1] / (double) scale::hsv_value);
}


void
slider::blend_hsv_sat (void)
{
	blend::hsv_sat (row_buffer, row_buff_size,
		additional_components [0] / (double) scale::hsv_hue,
		additional_components [1] / (double) scale::hsv_value);
}


void
slider::blend_hsv_value (void)
{
	blend::hsv_val (row_buffer, row_buff_size,
		additional_components [0] / (double) scale::hsv_hue,
		additional_components [1] / (double) scale::hsv_sat);
}
						  

void
slider::blend_hls_hue (void)
{
	blend::hls_hue (row_buffer, row_buff_size,
		additional_components [0] / (double) scale::hls_light,
		additional_components [1] / (double) scale::hls_sat);
}


void
slider::blend_hls_light (void)
{
	blend::hls_light (row_buffer, row_buff_size,
		additional_components [0] / (double) scale::hls_hue,
		additional_components [1] / (double) scale::hls_sat);
}
						  

void
slider::blend_hls_sat (void)
{
	blend::hls_sat (row_buffer, row_buff_size,
		additional_components [0] / (double) scale::hls_hue,
		additional_components [1] / (double) scale::hls_light);
}

} // xgui namespace
