// xgui 0.0.4 / 2002-08-07
//	slider_wrapper.inl
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_slider_wrapper_h
#define	_slider_wrapper_h

#include "slider.h"


namespace xgui {

namespace wrapper {

class slider
{
public:
	inline slider (void);
	inline slider (
		IN HWND window);

	// attaches class instance to a control
	inline void	attach (
		IN HWND window);

	// detaches control from the class instance
	inline void	detach (void);

	// returns whether class instance is currently attached to a control
	inline bool	attached (void) const;

	// returns window handle for control class is attached with
	inline HWND	window_handle (void) const;

	// attaches control to a master (controller)
	inline void	master_attach (
		IN HWND window);

public:
	// set/get slider's current layout bit mask (xgui::slider::layouts - "slider.h")
	inline int layout (void) const;
	inline void	layout (
		IN int value);

	// set/get slider's current visual mode (xgui::modes::visual - "xgui_constants.h")
	inline int	visual (void) const;
	inline void	visual (
		IN int value);

	// sets slider range (values at start and at the end of the slider)
	inline void range (
		IN int start_val,
		IN int end_val);

	// set/get value at the start of the slider
	inline int start (void) const;
	inline void	start (
		IN int value);

	// set/get value at the end of the slider
	inline int end (void) const;
	inline void	end (
		IN int value);

	// set/get current position
	inline int position (void) const;
	inline void	position (
		IN int value);

	// set/get index-th component
	inline int component (
		IN int index) const;
	inline void	component (
		IN int index,
		IN int value);

private:
	HWND	hwnd;
};


inline slider::slider (void)
{
	hwnd = NULL;
}


inline slider::slider (
	IN HWND window)
	: hwnd (window)
{
}


inline void
slider::attach (
	IN HWND window)
{
	hwnd = window;
}


inline void
slider::detach (void)
{
	hwnd = NULL;
}


inline bool
slider::attached (void) const
{
	return (hwnd != NULL);
}


inline HWND
slider::window_handle (void) const
{
	return (hwnd);
}


inline void
slider::master_attach (
	IN HWND window)
{
	SendMessage (hwnd, xgui::messages::master_attach, 0, (LPARAM) window);
}


inline int
slider::layout (void) const
{
	return ((int) SendMessage (hwnd, xgui::messages::layout_get, 0, 0));
}


inline void
slider::layout (
	IN int value)
{
	SendMessage (hwnd, xgui::messages::layout_set, 0, value);
}


inline int
slider::visual (void) const
{
	return ((int) SendMessage (hwnd, xgui::messages::visual_get, 0, 0));
}


inline void
slider::visual (
	IN int value)
{
	SendMessage (hwnd, xgui::messages::visual_set, 0, value);
}


inline void
slider::range (
	IN int start_val,
	IN int end_val)
{
	start (start_val);
	end (end_val);
}


inline int
slider::start (void) const
{
	return ((int) SendMessage (hwnd, xgui::messages::start_get, 0, 0));
}


inline void
slider::start (
	IN int value)
{
	SendMessage (hwnd, xgui::messages::start_set, 0, (LPARAM) value);
}


inline int
slider::end (void) const
{
	return ((int) SendMessage (hwnd, xgui::messages::end_get, 0, 0));
}


inline void
slider::end (
	IN int value)
{
	SendMessage (hwnd, xgui::messages::end_set, 0, (LPARAM) value);
}


inline int
slider::position (void) const
{
	return ((int) SendMessage (hwnd, xgui::messages::pos_get, 0, 0));
}


inline void
slider::position (
	IN int value)
{
	SendMessage (hwnd, xgui::messages::pos_set, 0, (LPARAM) value);
}


inline int
slider::component (
	IN int index) const
{
	return ((int) SendMessage (hwnd, xgui::messages::component_get, index, 0));
}


inline void
slider::component (
	IN int index,
	IN int value)
{
	SendMessage (hwnd, xgui::messages::component_set, index, value);
}


} // wrapper namespace

} // xgui namespace

#endif	// _slider_wrapper_h
