// xgui 0.0.4 / 2002-08-07
//	well.cpp
//
//	http://606u.dir.bg/
//	606u@dir.bg

#include "_p.h"

#include "well.h"


namespace xgui {


// well's static members initialization
const char	*well::class_name = "xgui_well";
WNDCLASS	well::window_class = { 0 };
ATOM		well::class_atom = 0;


well::well (void)
{
	color = RGB (0, 0, 0);
}


well::~well ()
{
}


bool
well::register_class (
	IN HINSTANCE library_instance)
{
	setup_wndclass (window_class, library_instance, class_name);
	return (wndclass::reg (class_name, &window_class, &class_atom));
}


bool
well::unregister_class (
	IN HINSTANCE library_instance)
{
	return (wndclass::unreg (library_instance, class_name));
}


void
well::paint (
	IN LPPAINTSTRUCT pnt)
{
	HDC		hdc = pnt->hdc;
	HBRUSH	fill_brush, old_brush;

	fill_brush = CreateSolidBrush (color);
	old_brush = (HBRUSH) SelectObject (hdc, fill_brush);
	SelectObject (hdc, GetStockObject (NULL_PEN));
	Rectangle (hdc, frame.left + 2, frame.top + 2, frame.right, frame.bottom);
	panel::draw (hdc, &frame,
		panel::sunken | panel::blackbox);
	SelectObject (hdc, old_brush);
	DeleteObject (fill_brush);
}


bool
well::size_changed (
	IN int hsize,
	IN int vsize)
{
	if (!base::size_changed (hsize, vsize))
		return (false);
	frame.right--;
	frame.bottom--;
	return (true);
}


LRESULT
well::control_message (
	IN enum control_codes message,
	IN WPARAM wparam,
	IN LPARAM lparam)
{
	LRESULT		result;

	// ask base class first
	result = base::control_message (message, wparam, lparam);
	if (result)
		return (result);

	switch (message)
	{
	case	messages::color_get:	return (color);
	case	messages::color_set:
		if (color == (COLORREF) lparam) return (0);
		debug_state ("color_set = 0x%08x", lparam);
		color = (COLORREF) lparam; break;
	default:
		debug_message ("well::control_message: unknown - m %d, w %d, l %d.", message, wparam, lparam);
		break;
	}
	InvalidateRect (hwnd, NULL, FALSE);
	return (0);
}

} // xgui namespace
