// xgui 0.0.4 / 2002-08-07
//	well_wrapper.inl
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_well_wrapper_h
#define	_well_wrapper_h

#include "well.h"


namespace xgui {

namespace wrapper {

class well
{
public:
	inline well (void);
	inline well (
		IN HWND window);

	// attaches class instance to a control
	inline void	attach (
		IN HWND window);

	// detaches control from the class instance
	inline void	detach (void);

	// returns whether class instance is currently attached to a control
	inline bool	attached (void) const;

	// returns window handle for control class is attached with
	inline HWND	window_handle (void) const;

	// attaches control to a master (controller)
	inline void	master_attach (
		IN HWND window);

public:
	// get/set current color
	inline COLORREF	color (void) const;
	inline void	color (
		IN COLORREF new_color);

private:
	HWND	hwnd;
};


inline well::well (void)
{
	hwnd = NULL;
}


inline well::well (
	IN HWND window)
	: hwnd (window)
{
}


inline void
well::attach (
	IN HWND window)
{
	hwnd = window;
}


inline void
well::detach (void)
{
	hwnd = NULL;
}


inline bool
well::attached (void) const
{
	return (hwnd != NULL);
}


inline HWND
well::window_handle (void) const
{
	return (hwnd);
}


inline void
well::master_attach (
	IN HWND window)
{
	SendMessage (hwnd, xgui::messages::master_attach, 0, (LPARAM) window);
}


inline COLORREF
well::color (void) const
{
	return ((COLORREF) SendMessage (hwnd, xgui::messages::color_get, 0, 0));
}


inline void
well::color (
	IN COLORREF new_color)
{
	SendMessage (hwnd, xgui::messages::color_set, 0, (LPARAM) new_color);
}


} // wrapper namespace

} // xgui namespace

#endif	// _well_wrapper_h
