// xgui 0.0.4 / 2002-08-07
//	xgui.h
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_xgui_h
#define	_xgui_h

#include "xgui_constants.h"
#include "xgui_statics.h"
#include "base.h"


namespace xgui {


// window proc for all classes
LRESULT CALLBACK wnd_proc (
	IN HWND hwnd,
	IN UINT message,
	IN WPARAM wparam,
	IN LPARAM lparam);


#if	defined (_DEBUG)
void debug_message (
	IN const char *format, ...);
#else
// no debug messages for release mode
inline void debug_message (
	IN const char* /* format */, ...) { };
#endif


inline void setup_wndclass (
	IN WNDCLASS &window_class,
	IN HINSTANCE library_instance,
	IN const char *class_name)
{
	// class will be visible by all applications, will accept doubleclicks
	//	and will be fully redrawn if its size is changed
	window_class.style = CS_GLOBALCLASS | CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
	window_class.lpfnWndProc = wnd_proc;
	window_class.cbClsExtra = 0;
	window_class.cbWndExtra = sizeof (base *);
	window_class.hInstance = library_instance;
	window_class.hIcon = 0;
	window_class.hCursor = LoadCursor (NULL, IDC_ARROW);
	window_class.hbrBackground = NULL;
	window_class.lpszMenuName = NULL;
	window_class.lpszClassName = class_name;
}


#define	XGUI_MEASURE()	\
	{	\
		static int	start = GetTickCount ();	\
		static int	count = 0;	\
		static const int	max = 1000;	\
		count++;	\
		if (count == max)	\
		{	\
			char	buff [100];	\
			count = GetTickCount () - start;	\
			sprintf (buff, "%d ms, %.1fms", count, (double) count / max);	\
			MessageBox (NULL, buff, "measure results", MB_OK);	\
		}	\
		else if (count < max)	\
			InvalidateRect (hwnd, NULL, FALSE);	\
	}


// make sure x is in range [start, end]
template <class T, class T1> void in_range (
	IN T& x,
	IN T1 start,
	IN T1 end)
{
	if (x < static_cast <T> (start)) x = static_cast <T> (start);
	if (x > static_cast <T> (end)) x = static_cast <T> (end);
}


// make sure x is in range [start, end] when start < end
//	or in [end, start] when end < start
template <class T, class T1> void in_between (
	IN T& x,
	IN T1 start,
	IN T1 end)
{
	if (start < end)
	{
		if (x < static_cast <T> (start)) x = static_cast <T> (start);
		if (x > static_cast <T> (end)) x = static_cast <T> (end);
	}
	else
	{
		if (x < static_cast <T> (end)) x = static_cast <T> (end);
		if (x > static_cast <T> (start)) x = static_cast <T> (start);
	}
}


} // xgui namespace


#endif	// _xgui_h
