// xgui 0.0.4 / 2002-08-07
//	xgui_constants.h
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_xgui_constants_h
#define	_xgui_constants_h


namespace xgui {


namespace modes {

	// visual modes definitions
	//	(existing should not be modified - used as indexes)
	enum visual
	{
		rgb_red = 0,
		rgb_green = 1,
		rgb_blue = 2,
		hsv_hue = 3,
		hsv_sat = 4,
		hsv_value = 5,
		hls_hue = 6,
		hls_light = 7,
		hls_sat = 8,
		max, // terminator - mode should be a number in [0, max)
		mask = 0x7F,
		reverse = 0x80
	};

} // modes namespace


namespace messages {

	// user-controls control messages
	enum control_codes
	{
		not_used = WM_USER + 1,

		master_attach,	// attach/detach master (controller) control
		master_detach,

#if	defined (_DEBUG)
		debug_window_attach,	// attach debug window (edit box) to track control state
#endif

		palette_set,	// set palette; lparam = palette id from the resources
		palette_attach,	// attach palette; lparam = ptr to palette object - all should be in the same process

		visual_get,		// get/set control's visual mode
		visual_set,

		component_get,	// get/set additional component's value
		component_set,

		layout_get,		// get/set control's layout (control-dependant)
		layout_set,

		color_get,		// get/set control's color
		color_set,

		xpos_get,		// get/set picker's x-axis position
		xpos_set,

		ypos_get,		// get/set picker's y-axis position
		ypos_set,

		pos_get,		// get/set slider's position
		pos_set,

		start_get,		// get/set slider's value @ start
		start_set,

		end_get,		// get/set slider's value @ end
		end_set,

		notification,	// notification message sent by the controller

		slave_get,		// get/set slave control (for the controller)
		slave_set,
	};

	// notification messages thrown from user controls
	enum notification_messages
	{
		drag = 0x10000000,		// mouse-drag in progress
		release = 0x20000000,	// mouse-drag is finished (drop)
		mask = 0xF0000000		// notification messages mask
	};

} // ctlmessage namespace


namespace scale {

	// coefficients to scale color components with to calculate real component value
	enum values
	{
		rgb = 1,
		rgb_red = rgb,
		rgb_green = rgb,
		rgb_blue = rgb,
		hsv_hue = 10,
		hsv_sat = 1000,
		hsv_value = 1000,
		hls_hue = 10,
		hls_light = 1000,
		hls_sat = 1000
	};

} // scale namespace


namespace max {

	// maximal number of color components (3 for all - RGB, HSV, HLS)
	//	should be set to 4 if CMYK is created
	const int components = 3;

	// maximal values for color components
	enum values
	{
		rgb = 255,
		rgb_red = rgb,
		rgb_green = rgb,
		rgb_blue = rgb,
		hsv_hue = 3599,
		hsv_sat = 1000,
		hsv_value = 1000,
		hls_hue = 3599,
		hls_light = 1000,
		hls_sat = 1000
	};

	// picker visual modes against max_component, max_x and max_y
	//	first one is changed with a slider; second is picker's horizontal; last is vertical
	const int	picker [modes::max][components] =
	{
		{ rgb_red, rgb_blue, rgb_green },	// rgb red: Rx, B>, G^
		{ rgb_green, rgb_blue, rgb_red },	// rgb green: Gx, B>, R^
		{ rgb_blue, rgb_red, rgb_green },	// rgb blue: Bx, R>, G^
		{ hsv_hue, hsv_sat, hsv_value },	// hsv hue: Hx, S>, V^
		{ hsv_sat, hsv_hue, hsv_value },	// hsv sat: Sx, H>, V^
		{ hsv_value, hsv_hue, hsv_sat },	// hsv value: Vx, H>, S^
		{ hls_hue, hls_sat, hls_light },	// hls hue: Hx, L>, S^
		{ hls_light, hls_hue, hls_sat },	// hls light: Lx, H>, S^
		{ hls_sat, hls_hue, hls_light }		// hls sat: Sx, H>, L^
	};

	// slider visual modes against max, max_component_1 and max_component_2
	const int	slider [modes::max][components] =
	{
		{ rgb_red, rgb_green, rgb_blue },	// rgb red: R, G, B
		{ rgb_green, rgb_red, rgb_blue },	// rgb green: G, R, B
		{ rgb_blue, rgb_red, rgb_green },	// rgb blue: B, R, G
		{ hsv_hue, hsv_sat, hsv_value },	// hsv hue: H, S, V
		{ hsv_sat, hsv_hue, hsv_value },	// hsv sat: S, H, V
		{ hsv_value, hsv_hue, hsv_sat },	// hsv value: V, H, S
		{ hls_hue, hls_light, hls_sat },	// hls hue: H, L, S
		{ hls_light, hls_hue, hls_sat },	// hls light: L, H, S
		{ hls_sat, hls_hue, hls_light }		// hls sat: S, H, L
	};

} // max namespace


} // xgui namespace


#endif	// _xgui_constants_h
