// xgui 0.0.4 / 2002-08-07
//	xgui_statics.h
//
//	http://606u.dir.bg/
//	606u@dir.bg

#ifndef	_xgui_statics_h
#define	_xgui_statics_h

#include "math.h"

namespace xgui {


// set following constant to 1 in order to use faster blend drawing algorithms
//	(BTW this is the way to see the importance of custom code tuning ;)
const int FAST_BLENDS = 1;

// when set to 1 will use better (more precise) palette-applying routine,
//	but will run slower; works fine on PII/350
const int BETTER_PALETTE = 1;


// number of bits to extend with when using integer math
//	instead of floating-point math (in the sake of speed)
//	probably 16 is the best, because it's a word
//	and compiler is trowing out several shifts
const int	int_extend = 16;
const int	int_extend_multiply = (1 << int_extend);


inline double
round (
	IN double v)
{
	// ceil (a - 0.5) = round (a) = floor (a + 0.5)
	return (floor (v + 0.5));
}


inline int
to_int (
	IN double v)
{
	return ((int) round (v));
}


namespace panel {

	// draw_panel flags bit mask
	enum flags
	{
		raised = 1,
		sunken = 2,
		blackbox = 4
	};

	// draws a rectangle with 3D border, where border appearance depends on flags
	void
	draw (
		IN HDC hdc,
		IN int left,
		IN int top,
		IN int right,
		IN int bottom,
		IN int flags);

	inline void
	draw (
		IN HDC hdc,
		IN LPRECT rc,
		IN int flags)
	{
		draw (hdc, rc->left, rc->top, rc->right, rc->bottom, flags);
	};

} // panel namespace


namespace triangle {

	enum types
	{
		left = 1,
		top = 2,
		right = 3,
		bottom = 4,
		left_top = 5,
		left_bottom = 6,
		right_top = 7,
		right_bottom = 8
	};

	// draws a triangle pointing in the "type" direction
	void
	draw (
		IN HDC hdc,
		IN int x,
		IN int y,
		IN enum types type,
		IN int size,
		IN COLORREF line_color,
		IN COLORREF fill_color);

} // triangle namespace


namespace box {

	// draws a square box
	void
	draw (
		IN HDC hdc,
		IN int left,
		IN int top,
		IN int side,
		IN COLORREF line_color,
		IN COLORREF fill_color);

} // rectangle namespace


namespace convert {

	// converts from HSV to RGB color model
	// inputs: hue in [0.0, 360.0], sat in [0.0, 1.0], value in [0.0, 1.0]
	// outputs: red, green and blue are all in [0.0, 1.0]
	int
	hsv2rgb (
		IN double hue,
		IN double sat,
		IN double value,
		OUT double *red,
		OUT double *green,
		OUT double *blue);

	// converts from RGB to HSV color model
	// inputs: red, green and blue are all in [0.0, 1.0]
	// outputs: hue in [0.0, 360.0], sat in [0.0, 1.0], value in [0.0, 1.0]
	int
	rgb2hsv (
		IN double red,
		IN double green,
		IN double blue,
		OUT double *hue,
		OUT double *sat,
		OUT double *value);

	// converts from HSV to RGB color model
	// inputs: hue in [0.0, 360.0], sat in [0.0, 1.0], value in [0.0, 1.0]
	// output: Windows' COLORREF RGB (on x86 0x00BBGGRR)
	inline COLORREF
	hsv2rgb (
		IN double hue,
		IN double sat,
		IN double value)
	{
		double	red, green, blue;

		if (hsv2rgb (hue, sat, value, &red, &green, &blue) == 0)
			return (RGB (
				round (red * 255.0),
				round (green * 255.0),
				round (blue * 255.0)));
		return (RGB (0, 0, 0));
	};

	// returns a HLS coeficient; internally used
	double
	hls_value (
		IN double n1,
		IN double n2,
		IN double hue);

	// converts from HLS to RGB color model
	// inputs: hue in [0.0, 360.0], light in [0.0, 1.0], sat in [0.0, 1.0]
	// outputs: red, green and blue are all in [0.0, 1.0]
	int
	hls2rgb (
		IN double hue,
		IN double light,
		IN double sat,
		OUT double *red,
		OUT double *green,
		OUT double *blue);

	// converts from RGB to HLS color model
	// inputs: red, green and blue are all in [0.0, 1.0]
	// outputs: hue in [0.0, 360.0], light in [0.0, 1.0], sat in [0.0, 1.0]
	int
	rgb2hls (
		IN double red,
		IN double green,
		IN double blue,
		OUT double *hue,
		OUT double *light,
		OUT double *sat);

	// converts from HSV to RGB color model
	// inputs: hue in [0.0, 360.0], light in [0.0, 1.0], sat in [0.0, 1.0]
	// output: Windows' COLORREF RGB (on x86 0x00BBGGRR)
	inline COLORREF
	hls2rgb (
		IN double hue,
		IN double light,
		IN double sat)
	{
		double	red, green, blue;

		if (hls2rgb (hue, light, sat, &red, &green, &blue) == 0)
			return (RGB (
				round (red * 255.0),
				round (green * 255.0),
				round (blue * 255.0)));
		return (RGB (0, 0, 0));
	}

	// converts a Windows' COLORREF as RGB to COLORREF as BGR
	// (on x86 RGB means 0x00BBGGRR and BGR means 0x00RRGGBB)
	inline COLORREF
	bgr (
		IN COLORREF rgb)
	{
		return (RGB (GetBValue (rgb), GetGValue (rgb), GetRValue (rgb)));
	}

	// converts a 3 separate scaled (shifted right int_extend-bits)
	// RGB components into Windows' COLORREF RGB (on x86 0x00BBGGRR)
	inline COLORREF
	scaled2rgb (
		IN int red,
		IN int green,
		IN int blue)
	{
		return (RGB (red >> int_extend, green >> int_extend, blue >> int_extend));
	}

	// converts a 3 separate scaled (shifted right int_extend-bits)
	// RGB components into Windows' COLORREF BGR (on x86 0x00RRGGBB)
	inline COLORREF
	scaled2bgr (
		IN int red,
		IN int green,
		IN int blue)
	{
		return (RGB (blue >> int_extend, green >> int_extend, red >> int_extend));
	}

	// returns scaled red component from a Windows' COLORREF RGB
	inline int
	scaled_red (
		IN COLORREF c)
	{
		return (GetRValue (c) << int_extend);
	}

	// returns scaled green component from a Windows' COLORREF RGB
	inline int
	scaled_green (
		IN COLORREF c)
	{
		return (GetGValue (c) << int_extend);
	}

	// returns scaled blue component from a Windows' COLORREF RGB
	inline int
	scaled_blue (
		IN COLORREF c)
	{
		return (GetBValue (c) << int_extend);
	}

	// converts 24-bit Windows' COLORREF RGB (on x86 32-bit 0x00BBGGRR)
	// to 12-bit RGB index (on x86 16-bit 0x0BGR)
	inline short RGB24_2_RGB12 (
		IN COLORREF c)
	{
		if (BETTER_PALETTE)
		{
			// scale 8-bits to 4 with rounding
			static unsigned char scale_256_to_16 [256] =
			{
/*  9 * 0x00 */	 0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 17 * 0x01 */	 1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
/* 17 * 0x02 */	 2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
/* 17 * 0x03 */	 3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
/* 17 * 0x04 */	 4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
/* 17 * 0x05 */	 5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* 17 * 0x06 */	 6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* 17 * 0x07 */	 7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* 17 * 0x08 */	 8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
/* 17 * 0x09 */	 9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
/* 17 * 0x0A */	10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
/* 17 * 0x0B */	11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
/* 17 * 0x0C */	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
/* 17 * 0x0D */	13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
/* 17 * 0x0E */	14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
/*  9 * 0x0F */	15, 15, 15, 15, 15, 15, 15, 15, 15
			};
			// 00BBGGRR assumed!
			return ((short) (
				scale_256_to_16 [c >>  0 & 0xFF] << 0 |
				scale_256_to_16 [c >>  8 & 0xFF] << 4 |
				scale_256_to_16 [c >> 16 & 0xFF] << 8));
		}
		else
			// 00BBGGRR assumed!
			return ((short) (
				((c & 0xF0) >> 4) |
				((c & 0xF000) >> 8) |
				((c & 0xF00000) >> 12)));
	}

	// converts 24-bit Windows' COLORREF BGR (on x86 32-bit 0x00RRGGBB)
	// to 12-bit RGB index (on x86 16-bit 0x0BGR)
	inline short BGR24_2_RGB12 (
		IN COLORREF c)
	{
		if (BETTER_PALETTE)
		{
			// scale 8-bits to 4 with rounding
			static unsigned char scale_256_to_16 [256] =
			{
/*  9 * 0x00 */	 0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 17 * 0x01 */	 1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
/* 17 * 0x02 */	 2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
/* 17 * 0x03 */	 3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
/* 17 * 0x04 */	 4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
/* 17 * 0x05 */	 5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
/* 17 * 0x06 */	 6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* 17 * 0x07 */	 7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
/* 17 * 0x08 */	 8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
/* 17 * 0x09 */	 9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
/* 17 * 0x0A */	10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
/* 17 * 0x0B */	11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
/* 17 * 0x0C */	12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
/* 17 * 0x0D */	13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
/* 17 * 0x0E */	14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
/*  9 * 0x0F */	15, 15, 15, 15, 15, 15, 15, 15, 15
			};
			// 00RRGGBB assumed!
			return ((short) (
				scale_256_to_16 [c >> 16 & 0xFF] << 0 |
				scale_256_to_16 [c >>  8 & 0xFF] << 4 |
				scale_256_to_16 [c >>  0 & 0xFF] << 8));
		}
		else
			// 00RRGGBB assumed!
			return ((short) (
				((c & 0xF0) << 4) |
				((c & 0xF000) >> 8) |
				((c & 0xF00000) >> 20)));
	}

} // convert namespace


namespace blend {

	// fills buffer with requested number of Windows' COLORREF BGR samples
	// making a RGB blend, where first position contains RGB color start
	// and last position contains RGB color end
	void
	rgb (
		OUT DWORD *buffer,
		IN int samples,
		IN COLORREF start,
		IN COLORREF end,
		IN OPTIONAL bool use_fast_blends = FAST_BLENDS);

	// fills buffer with requested number of Windows' COLORREF BGR samples
	// making a HSV blend, where first position is having hue = 0.0
	// and last position is having hue = 360.0
	// saturation and value are constants
	void
	hsv_hue (
		OUT DWORD *buffer,
		IN int samples,
		IN double sat,
		IN double val,
		IN OPTIONAL bool use_fast_blends = FAST_BLENDS);

	// fills buffer with requested number of Windows' COLORREF BGR samples
	// making a HSV blend, changing saturation in [0.0, 1.0]
	void
	hsv_sat (
		OUT DWORD *buffer,
		IN int samples,
		IN double hue,
		IN double val,
		IN OPTIONAL bool use_fast_blends = FAST_BLENDS);

	// fills buffer with requested number of Windows' COLORREF BGR samples
	// making a HSV blend, changing value in [0.0, 1.0]
	void
	hsv_val (
		OUT DWORD *buffer,
		IN int samples,
		IN double hue,
		IN double sat,
		IN OPTIONAL bool use_fast_blends = FAST_BLENDS);

	// fills buffer with requested number of Windows' COLORREF BGR samples
	// making a HLS blend, changing hue in [0.0, 360.0]
	void
	hls_hue (
		OUT DWORD *buffer,
		IN int samples,
		IN double light,
		IN double sat,
		IN OPTIONAL bool use_fast_blends = FAST_BLENDS);

	// fills buffer with requested number of Windows' COLORREF BGR samples
	// making a HLS blend, changing light in [0.0, 1.0]
	void
	hls_light (
		OUT DWORD *buffer,
		IN int samples,
		IN double hue,
		IN double sat,
		IN OPTIONAL bool use_fast_blends = FAST_BLENDS);

	// fills buffer with requested number of Windows' COLORREF BGR samples
	// making a HLS blend, changing saturation in [0.0, 1.0]
	void
	hls_sat (
		OUT DWORD *buffer,
		IN int samples,
		IN double hue,
		IN double light,
		IN OPTIONAL bool use_fast_blends = FAST_BLENDS);

} // blend namespace


namespace mem {

	// = memset, but uses a doubleword as value instead of a byte
	// and number of dwords is given instead of number of bytes
	inline void
	set (
		OUT unsigned long *buffer,
		IN unsigned long value,
		IN size_t count)
	{
		while (count--)
			*buffer++ = value;
	};

	// = memset, but uses a doubleword as value instead of a byte
	// and number of dwords is given instead of number of bytes
	// updates buffer pointer position to be the 1-st dword after the last dword set
	inline void
	set (
		OUT unsigned long **buffer,
		IN unsigned long value,
		IN size_t count)
	{
		unsigned long	*p = *buffer;
		
		while (count--)
			*p++ = value;
		*buffer = p;
	};

	// = memcpy, but moves dwords instead of bytes
	// count should be the number of dwords to move
	inline void
	copy (
		OUT unsigned long *target,
		IN const unsigned long *source,
		size_t count)
	{
		while (count--)
			*target++ = *source++;
	};

	// = memcpy, but moves dwords instead of bytes
	// count should be the number of dwords to copy
	// updates buffer pointer position to be the 1-st dword after the last dword copied
	inline void
	copy (
		OUT unsigned long **target,
		IN const unsigned long *source,
		IN size_t count)
	{
		unsigned long	*p = *target;

		while (count--)
			*p++ = *source++;
		*target = p;
	};

	// similar to copy, but target buffer will contain reverse of the source one
	// in the matter of dwords; count should be the number of dwords to copy
	inline void
	copy_reverse (
		OUT unsigned long *target,
		IN const unsigned long *source,
		IN size_t count)
	{
		source += (count - 1);
		while (count--)
			*target++ = *source--;
	};

	// will reverse a buffer (make a mirror against its middle)
	// count should be number of dwords to reverse
	inline void
	reverse (
		IN OUT unsigned long *buffer,
		IN size_t count)
	{
		unsigned long	*p = buffer + count - 1;

		while (buffer < p)
		{
			*buffer ^= *p;
			*p ^= *buffer;
			*buffer++ ^= *p--;
		}
	};

} // mem namespace


namespace wndclass {

	bool reg (
		IN const char *class_name,
		IN WNDCLASS *window_class,
		IN ATOM *class_atom);

	bool unreg (
		IN HINSTANCE library_instance,
		IN const char *class_name);

};


} // xgui namespace

#endif	// _xgui_statics_h
