// xgui 0.0.4 / 2002-08-07
//	xgui_wnd_proc.cpp
//
//	http://606u.dir.bg/
//	606u@dir.bg

#include "_p.h"

#include "well.h"
#include "slider.h"
#include "picker.h"
#include "gradient.h"
#include "controller.h"


namespace xgui {

LRESULT CALLBACK
wnd_proc (
	IN HWND hwnd,
	IN UINT message,
	IN WPARAM wparam,
	IN LPARAM lparam)
{
	LONG	address;
	LRESULT	result;
	base	*class_instance;

	// get pointer to class instance
	SetLastError (0);
	address = GetWindowLong (hwnd, 0);
	if (address == 0)
	{
		// class instance is not created and pointer is not attached yet
		//	under normal circumstances, this could only happen on WM_NCCREATE message
		result = GetLastError ();
		if (GetLastError () == 0 &&
			message == WM_NCCREATE)
		{
			LPCREATESTRUCT	new_window = (LPCREATESTRUCT) lparam;

			// recognize class name and create class instance
			class_instance = NULL;
			if (stricmp (new_window->lpszClass, well::class_name) == 0)
				class_instance = new well;
			else if (stricmp (new_window->lpszClass, slider::class_name) == 0)
				class_instance = new slider;
			else if (stricmp (new_window->lpszClass, picker::class_name) == 0)
				class_instance = new picker;
			else if (stricmp (new_window->lpszClass, gradient::class_name) == 0)
				class_instance = new gradient;
			else if (stricmp (new_window->lpszClass, controller::class_name) == 0)
				class_instance = new controller;
			else
				debug_message ("xgui_wnd_proc: window class unknown '%s'.", new_window->lpszClass);

			// setup class instance
			if (class_instance &&
				!class_instance->setup (hwnd, (LPCREATESTRUCT) lparam))
			{
				delete class_instance;
				class_instance = NULL;
			}

			// attach to the newly created window
			if (class_instance)
			{
				SetLastError (0);
				if (SetWindowLong (hwnd, 0, (LONG) class_instance) == 0)
					if (GetLastError () == 0)
						// success
						return (TRUE);
			}
		}
		// failed
		return (FALSE);
	}
	else
		class_instance = (base *) address;

	// process message
	result = 0;
	switch (message)
	{
	case	WM_NCHITTEST:
		result = class_instance->hit_test (
			LOWORD (lparam), HIWORD (lparam)) ? HTCLIENT : HTNOWHERE;
		break;

	case	WM_GETDLGCODE:
		result = class_instance->input_filter ();
		break;

	case	WM_NCDESTROY:
		// 0 is success for WM_NCDESTROY
		delete class_instance;
		result = 0;
		break;

	case	WM_MOUSEMOVE:
		class_instance->mouse_move (LOWORD (lparam), HIWORD (lparam), wparam);
		result = 0;
		break;

	case	WM_LBUTTONDOWN:
		class_instance->mouse_down (
			base::button_left, LOWORD (lparam), HIWORD (lparam), wparam);
		result = 0;
		break;

	case	WM_LBUTTONUP:
		class_instance->mouse_up (
			base::button_left, LOWORD (lparam), HIWORD (lparam), wparam);
		result = 0;
		break;

	case	WM_KEYDOWN:
		class_instance->key_down (wparam, lparam);
		result = 0;
		break;

	case	WM_SETFOCUS:
		class_instance->focused ();
		result = 0;
		break;

	case	WM_KILLFOCUS:
		class_instance->blurred ();
		result = 0;
		break;

	// (re-)paint window
	case	WM_PAINT:
		PAINTSTRUCT		ps;

		if (BeginPaint (hwnd, &ps) != NULL)
		{
			class_instance->paint (&ps);
			EndPaint (hwnd, &ps);
		}
		// 0 is success for WM_PAINT
		result = 0;
		break;

	case	WM_WINDOWPOSCHANGING:
		class_instance->size_changed (
			((LPWINDOWPOS) lparam)->cx, ((LPWINDOWPOS) lparam)->cy);
		result = 0;
		break;

	case	WM_SIZE:
		class_instance->size_changed (
			LOWORD (lparam), HIWORD (lparam));
		break;

	case	WM_SYSCOLORCHANGE:
	case	WM_DISPLAYCHANGE:
		class_instance->display_settings_changed ();
		break;

	default:
		// custom control messages
		if (message >= WM_USER && message <= 0x7FFF)
			return (class_instance->control_message (
				(enum xgui::control_codes) message, wparam, lparam));
		else
			return (DefWindowProc (hwnd, message, wparam, lparam));
		break;
	}

	return (result);
}

} // xgui namespace
